% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_time.R
\name{st_time}
\alias{st_time}
\alias{st_time<-}
\alias{st_time.sftime}
\alias{st_time<-.sf}
\alias{st_time<-.sftime}
\alias{st_set_time}
\alias{st_drop_time}
\title{Get, set, or replace time information}
\usage{
st_time(obj, ...)

st_time(x, ...) <- value

\method{st_time}{sftime}(obj, ...)

\method{st_time}{sf}(x, ..., time_column_name = "time") <- value

\method{st_time}{sftime}(x, ...) <- value

st_set_time(x, value, ...)

st_drop_time(x)
}
\arguments{
\item{obj}{An object of class \code{sftime}.}

\item{...}{Additional arguments; Ignored.}

\item{x}{An object of class \code{sftime} or \code{sf}.}

\item{value}{An object for which \code{\link{is_sortable}} returns 
\code{TRUE} or an object of class \code{character}, or \code{NULL}.}

\item{time_column_name}{Character value; The name of the column to set as 
active time column in \code{x}.}
}
\value{
\code{st_time} returns the content of the active time column of an
\code{sftime} object. 
Assigning an object for which \code{\link{is_sortable}} returns \code{TRUE} 
to an \code{sf} object creates an \code{\link[=st_sftime]{sftime}} object. 
Assigning an object for which \code{\link{is_sortable}} returns \code{TRUE} 
to an \code{sftime} object replaces the active time column by this object.
}
\description{
Get, set, or replace time information
}
\details{
In case \code{value} is character and \code{x} is of class 
\code{sftime}, the active time column (as indicated by attribute 
\code{time_column}) is set to \code{x[[value]]}.

The replacement function applied to \code{sftime} objects will overwrite the 
active time column, if \code{value} is \code{NULL}, it will remove it and 
coerce \code{x} to an \code{sftime} object.

\code{st_drop_time} drops the time column of its argument, and 
reclasses it accordingly.
}
\examples{
# from sftime object
g <- st_sfc(st_point(1:2))
time <- Sys.time()
x <- st_sftime(a = 3, g, time = time)
st_time(x) 

## assign a vector with time information

# to sf object
x <- st_sf(a = 3, g)
st_time(x) <- time
x

# to sftime object
x <- st_sftime(a = 3, g, time = time)
st_time(x) <- Sys.time()

## remove time column from sftime object
st_time(x) <- NULL

## pipe-friendly

# assign time column to sf object
x <- st_sf(a = 3, g)
x <- st_set_time(x, time)

# remove time column from sftime object
st_set_time(x, NULL)

## drop time column and class

# same as x <- st_set_time(x, NULL)
st_drop_time(x)

}
