% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-imports.R
\name{Imports}
\alias{Imports}
\title{R6 Class representing storage imports endpoints}
\description{
R6 Class representing storage imports resource endpoints.
}
\examples{

## ------------------------------------------------
## Method `Imports$query`
## ------------------------------------------------

\dontrun{
 imports_object <- Imports$new(
                    auth = auth
                   )

 # List import job
 imports_object$query()
}


## ------------------------------------------------
## Method `Imports$get`
## ------------------------------------------------

\dontrun{
 imports_object <- Imports$new(
                    auth = auth,
                   )

 # List import job
 imports_object$get(id = id)
}


## ------------------------------------------------
## Method `Imports$submit_import`
## ------------------------------------------------

\dontrun{
 imports_object <- Imports$new(
                    auth = auth
                   )

 # Submit new import into a project
 imports_object$submit_import(
  source_location = volume_file_object,
  destination_project = test_project_object,
  autorename = TRUE
 )
}

}
\section{Super class}{
\code{\link[sevenbridges2:Resource]{sevenbridges2::Resource}} -> \code{Imports}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Imports-new}{\code{Imports$new()}}
\item \href{#method-Imports-query}{\code{Imports$query()}}
\item \href{#method-Imports-get}{\code{Imports$get()}}
\item \href{#method-Imports-submit_import}{\code{Imports$submit_import()}}
\item \href{#method-Imports-delete}{\code{Imports$delete()}}
\item \href{#method-Imports-clone}{\code{Imports$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Imports-new"></a>}}
\if{latex}{\out{\hypertarget{method-Imports-new}{}}}
\subsection{Method \code{new()}}{
Create a new Imports object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Imports$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Imports-query"></a>}}
\if{latex}{\out{\hypertarget{method-Imports-query}{}}}
\subsection{Method \code{query()}}{
This call lists import jobs initiated by particular user.
Note that when you import a file from your volume on your cloud storage
provider (Amazon Web Services or Google Cloud Storage), you are
creating an alias on the Platform which points to the file in your
cloud storage bucket. Aliases appear as files on the Platform and can
be copied, executed, and modified as such. They refer back to the
respective file on the given volume.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Imports$query(
  volume = NULL,
  project = NULL,
  state = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{volume}}{Volume id or Volume object. List all imports
from this particular volume. Optional.}

\item{\code{project}}{Project id or Project object. List all volume
imports to this particular project. Optional.}

\item{\code{state}}{The state of the import job. Possible values are:
\itemize{
\item \code{PENDING}: the import is queued;
\item \code{RUNNING}: the import is running;
\item \code{COMPLETED}: the import has completed successfully;
\item \code{FAILED}: the import has failed.
}
Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{state = c("RUNNING", "FAILED")
}\if{html}{\out{</div>}}}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} of \code{\link{Import}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 imports_object <- Imports$new(
                    auth = auth
                   )

 # List import job
 imports_object$query()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Imports-get"></a>}}
\if{latex}{\out{\hypertarget{method-Imports-get}{}}}
\subsection{Method \code{get()}}{
This call will return the details of an import job.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Imports$get(id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The import job identifier (id).}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Import}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 imports_object <- Imports$new(
                    auth = auth,
                   )

 # List import job
 imports_object$get(id = id)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Imports-submit_import"></a>}}
\if{latex}{\out{\hypertarget{method-Imports-submit_import}{}}}
\subsection{Method \code{submit_import()}}{
This call lets you queue a job to import a file or folder
from a volume into a project on the Platform.
Essentially, you are importing an item from your cloud storage provider
(Amazon Web Services, Google Cloud Storage, Azure or Ali Cloud) via the
volume onto the Platform. \cr
If successful, an alias will be created on the Platform. Aliases appear
on the Platform and can be copied, executed, and modified as such.
They refer back to the respective item on the given volume. \cr

If you want to import multiple files, the recommended way is to do it
in bulk considering the API rate limit (\href{https://docs.sevenbridges.com/docs/api-rate-limit}{learn more}).
Bulk operations will be implemented in next releases.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Imports$submit_import(
  source_volume = NULL,
  source_location,
  destination_project = NULL,
  destination_parent = NULL,
  name = NULL,
  overwrite = FALSE,
  autorename = FALSE,
  preserve_folder_structure = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source_volume}}{Volume id or Volume object you want to import
files or folders from. Required if \code{source_location} parameter is
provided as a string.}

\item{\code{source_location}}{File/folder location name on the volume or
VolumeFile object you would like to import into some project/folder on
the platform.}

\item{\code{destination_project}}{Destination project id or Project
object. Not required, but either \code{destination_project} or
\code{destination_parent} directory must be provided.}

\item{\code{destination_parent}}{Folder id or File object
(with \code{type = 'FOLDER'}). Not required, but either \code{destination_project}
or \code{destination_parent} directory must be provided.}

\item{\code{name}}{The name of the alias to create. This name should be unique
to the project. \cr
If the name is already in use in the project, you should
use the \code{overwrite} query parameter in this call to force any item with
that name to be deleted before the alias is created.
If name is omitted, the alias name will default to the last segment of
the complete location (including the prefix) on the volume. \cr

Segments are considered to be separated with forward slashes /.
Allowed characters in file names are all alphanumeric and special
characters except forward slash /, while folder names can contain
alphanumeric and special characters _, - and ..}

\item{\code{overwrite}}{Set to \code{TRUE} if you want to overwrite the item if
another one with the same name already exists at the destination.
Bear in mind that if used with folders import, the folder's content
(files with the same name) will be overwritten, not the whole folder.}

\item{\code{autorename}}{Set to \code{TRUE} if you want to automatically rename the
item (by prefixing its name with an underscore and number) if another
one with the same name already exists at the destination.
Bear in mind that if used with folders import, the folder content will
be renamed, not the whole folder.}

\item{\code{preserve_folder_structure}}{Set to \code{TRUE} if you want to keep the
exact source folder structure. The default value is \code{TRUE} if the item
being imported is a folder. Should not be used if you are importing a
file. Bear in mind that if you use \code{preserve_folder_structure = FALSE},
that the response will be the parent folder object containing imported
files alongside with other files if they exist.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Import}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 imports_object <- Imports$new(
                    auth = auth
                   )

 # Submit new import into a project
 imports_object$submit_import(
  source_location = volume_file_object,
  destination_project = test_project_object,
  autorename = TRUE
 )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Imports-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Imports-delete}{}}}
\subsection{Method \code{delete()}}{
Deleting import jobs is not possible.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Imports$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Imports-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Imports-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Imports$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
