% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{reWeightParticles}
\alias{reWeightParticles}
\title{Update the importance weights of each particle.}
\usage{
reWeightParticles(spectra, peaks, baselines, i, start, sigma, old_weights,
  alpha, idx)
}
\arguments{
\item{spectra}{\code{n_y * nwl} Matrix of observed Raman spectra.}

\item{peaks}{\code{nwl * npart} Matrix containing the spectral signatures for each observation.}

\item{baselines}{\code{nwl * npart} Matrix containing the current values of the baselines.}

\item{i}{index of the current observation to use in calculating the likelihood}

\item{start}{index of the next wavelength to use in calculating the likelihood, permuted by \code{idx}}

\item{sigma}{Vector of \code{npart} standard deviations for each particle.}

\item{old_weights}{logarithms of the importance weights of each particle.}

\item{alpha}{the target learning rate for the reduction in effective sample size (ESS).}

\item{idx}{permutation of the indices of the wavelengths.}
}
\value{
a List containing:
\describe{
  \item{\code{ess}}{The effective sample size, after reweighting.}
  \item{\code{weights}}{Vector of updated importance weights.}
  \item{\code{index}}{index of the last wavelength used.}
  \item{\code{evidence}}{SMC estimate of the logarithm of the model evidence.}
}
}
\description{
Update the importance weights of each particle.
}
\references{
Pitt, dos Santos Silva, Giordani & Kohn (2012)
"On some properties of Markov chain Monte Carlo simulation methods based on the particle filter"
J. Econometrics 171(2): 134--151,
DOI: \href{http://dx.doi.org/10.1016/j.jeconom.2012.06.004}{10.1016/j.jeconom.2012.06.004}

Zhou, Johansen & Aston (2015) "Towards Automatic Model Comparison: An Adaptive Sequential Monte Carlo Approach"
\href{http://arxiv.org/abs/1303.3123}{arXiv:1303.3123} [stat.ME]
}
