% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{madansky}
\alias{madansky}
\title{Madansky's method}
\usage{
madansky(s, n, alpha, ...)
}
\arguments{
\item{s}{Vector of successes.}

\item{n}{Vector of sample sizes.}

\item{alpha}{The significance level; to calculate a 100(1-\eqn{\alpha})\% lower confidence bound.}

\item{...}{Additional arguments to be ignored.}
}
\value{
The 100(1-\eqn{\alpha})\% lower confidence bound. Note that if there are zero observed
    failures across all components, the output is LCB = 0.
}
\description{
Calculate a binomial series lower confidence bound using Madansky's (1965) method.
}
\examples{
madansky(s=c(35, 97, 59), n=c(35, 100, 60), alpha=.10)
}
