% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConfProb.R
\name{EstConf}
\alias{EstConf}
\title{Estimate confidence probability}
\usage{
EstConf(Ped = NULL, LifeHistData = NULL, Specs = NULL, Full = TRUE,
  nSim = 10, ParMis = 0.4, args.sim = NULL, return.PC = FALSE,
  quiet = TRUE)
}
\arguments{
\item{Ped}{Reference pedigree from which to simulate, dataframe with
columns id-dam-sire. Additional columns are ignored}

\item{LifeHistData}{Dataframe with id, sex (1=female, 2=male, 3=unknown),
and birth year.}

\item{Specs}{Parameter values for running sequoia, as named vector.}

\item{Full}{Full pedigree reconstruction (TRUE) or only parentage assignment
(FALSE)}

\item{nSim}{number of simulations to perform.}

\item{ParMis}{proportion of parents assumed to have a fully missing genotype.}

\item{args.sim}{list of additional arguments to pass to \code{\link{SimGeno}}}

\item{return.PC}{return all \code{\link{PedCompare}} \code{Counts}?}

\item{quiet}{suppress messages. `very' also suppresses simulation counter}
}
\value{
A 2x2 matrix for parentage assignment, or a 2x7x2 array for
 full pedigree reconstruction, with for dams and sires and per category (see
 \code{\link{PedCompare}}) the average and minimum number of Match/(Match +
 Mismatch + P2only).

When return.PC is TRUE, a list is returned with two arrays: ConfProb
contains the average confidence probability across simulations, and
SimCounts all counts of matches, mismatches, Pedigree1-only and pedigree2-
only per simulation.
}
\description{
Estimate the assignment error rate by repeatedly simulating
data from
a reference pedigree using \code{\link{SimGeno}}, reconstruction a pedigree
from this using \code{\link{sequoia}}, and counting the number of mismatches
using \code{\link{PedCompare}}.
}
\details{
The confidence probability is taken as the number of correct
(matching)
assignments, divided by all assignments made. A confidence of '1' should be
interpreted as '> 1 - 1/(sum(!is.na(Ped$dam)) * nSim)'
}
\examples{
\dontrun{
data(SimGeno_example, LH_HSg5, package="sequoia")
SeqOUT <- sequoia(GenoM = SimGeno_example,
                  LifeHistData = LH_HSg5, MaxSibIter = 0)
ConfPr <- EstConf(Ped = SeqOUT$PedigreePar, LifeHistData = LH_HSg5,
                 Specs = SeqOUT$Specs, Full = FALSE, nSim = 10)
}

}
