% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{ThinDataToDESeqDataSet}
\alias{ThinDataToDESeqDataSet}
\title{Converts a ThinData S3 object into a DESeqDataSet S4 object.}
\usage{
ThinDataToDESeqDataSet(obj)
}
\arguments{
\item{obj}{A ThinData S3 object. This is generally output by either
\code{\link{thin_diff}}, \code{\link{thin_2group}},
\code{\link{thin_lib}}, \code{\link{thin_gene}}, or
\code{\link{thin_all}}.}
}
\value{
A \code{\link[DESeq2]{DESeqDataSet}} S4
    object. This will allow you to insert the simulated
    data directly into DESeq2.
}
\description{
The design formula in the resulting DESeqDataSet is just the sum of all
variables in \code{designmat} from the ThinData object (except the
intercept term). You should change this design formula if you want to
study other models.
}
\examples{
\donttest{
## Generate simulated data and modify using thin_diff().
## In practice, you would use real data, not simulated.
set.seed(1)
n <- 10
p <- 1000
Z <- matrix(abs(rnorm(n, sd = 4)))
alpha <- matrix(abs(rnorm(p, sd = 1)))
mat <- round(2^(alpha \%*\% t(Z) + abs(matrix(rnorm(n * p, sd = 5),
                                            nrow = p,
                                            ncol = n))))
design_perm <- cbind(rep(c(0, 1), length.out = n), runif(n))
coef_perm   <- matrix(rnorm(p * ncol(design_perm), sd = 6), nrow = p)
design_obs  <- matrix(rnorm(n), ncol = 1)
target_cor <- matrix(c(0.9, 0))
thout <- thin_diff(mat            = mat,
                   design_perm    = design_perm,
                   coef_perm      = coef_perm,
                   target_cor     = target_cor,
                   design_obs     = design_obs,
                   permute_method = "hungarian")

## Convert ThinData object to DESeqDataSet object.
seobj <- ThinDataToDESeqDataSet(thout)
class(seobj)

## The "O1" variable in the colData corresponds to design_obs.
## The "P1" and "P2" variables in colData correspond to design_perm.
seobj
}

}
\author{
David Gerard
}
