% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samp_Discrete.R
\name{samp_discrete}
\alias{samp_discrete}
\title{Species Sampling uncertainty - Trait Evolution Discrete Characters}
\usage{
samp_discrete(
  data,
  phy,
  n.sim = 30,
  breaks = seq(0.1, 0.5, 0.1),
  model,
  transform = "none",
  bounds = list(),
  n.cores = NULL,
  track = TRUE,
  ...
)
}
\arguments{
\item{data}{Data vector for a single binary trait, with names matching tips in \code{phy}.}

\item{phy}{A phylogeny (class 'phylo') matching \code{data}.}

\item{n.sim}{The number of times species are randomly deleted for each \code{break}.}

\item{breaks}{A vector containing the percentages of species to remove.}

\item{model}{The Mkn model to use (see Details).}

\item{transform}{The evolutionary model to transform the tree (see Details). Default is \code{none}.}

\item{bounds}{settings to constrain parameter estimates. See \code{\link[geiger]{fitDiscrete}}}

\item{n.cores}{number of cores to use. If 'NULL', number of cores is detected.}

\item{track}{Print a report tracking function progress (default = TRUE)}

\item{...}{Further arguments to be passed to \code{\link[geiger]{fitDiscrete}}}
}
\value{
The function \code{tree_discrete} returns a list with the following
components:

\code{call}: The function call

\code{data}: The original full data vector

\code{optpar}: Transformation parameter used (e.g. \code{lambda}, \code{kappa} etc.)

\code{full.model.estimates}: Parameter estimates (transition rates q12 and q21), 
AICc and the optimised value of the phylogenetic transformation parameter (e.g. \code{lambda}) 
for the full model without deleted species.

\code{break.summary.tab}: Summary per \code{break} of the mean and median effects 
of species removal on percentage and absolute change in parameters q12 and q21.

\code{sensi.estimates}: Parameter estimates (transition rates q12 and q21),(percentual) difference 
in parameter estimate compared to the full model (DIFq12, sigsq.q12,sDIFq12, DIFq21, optpar.q21,sDIFq21),  
AICc and the optimised value of the phylogenetic transformation parameter (e.g. \code{lambda}) 
for each analysis with a species deleted.

\code{optpar}: Transformation parameter used (e.g. \code{lambda}, \code{kappa} etc.)
}
\description{
Fits models for trait evolution of discrete (binary) characters, 
evaluating sampling uncertainty.
}
\details{
This function randomly removes a given percentage of species (controlled by \code{breaks}),  
fits different models of discrete character evolution using \code{\link[geiger]{fitDiscrete}}, 
repeats this this many times (controlled by \code{n.sim}), stores the results and calculates 
the effects on model parameters Currently, only binary discrete traits are supported.

Different character model from \code{fitDiscrete} can be used, including \code{ER} (equal-rates), 
\code{SYM} (symmetric), \code{ARD} (all-rates-different) and \code{meristic} (stepwise fashion). 

Transformations to the phylogenetic tree from \code{fitDiscrete} can be used, i.e. \code{none},
\code{EB}, \code{lambda}, \code{kappa} and\code{delta}.

See \code{\link[geiger]{fitDiscrete}} for more details on character models and tree transformations. 

Output can be visualised using \code{sensi_plot}.
}
\examples{
\dontshow{
#Load data:
data("primates")
#Create a binary trait factor 
adultMass_binary<-ifelse(primates$data$adultMass > 7350, "big", "small")
adultMass_binary<-as.factor(as.factor(adultMass_binary))
names(adultMass_binary)<-rownames(primates$data)
#Model trait evolution accounting for phylogenetic uncertainty
samp_binary<-samp_discrete(data = adultMass_binary,phy = primates$phy[[1]],
n.sim=1,breaks=c(.1,.2),model = "SYM",transform = "none",n.cores = 2,track = TRUE)
}
\dontrun{
#Load data:
data("primates")
#Create a binary trait factor 
adultMass_binary<-ifelse(primates$data$adultMass > 7350, "big", "small")
adultMass_binary<-as.factor(as.factor(adultMass_binary))
names(adultMass_binary)<-rownames(primates$data)
#Model trait evolution accounting for sampling size 
samp_binary<-samp_discrete(data = adultMass_binary,phy = primates$phy[[1]],
n.sim=25,breaks=seq(.1,.3,.1),model = "SYM",transform = "none",n.cores = 2,track = TRUE)
#Print summary statistics
summary(samp_binary)
sensi_plot(samp_binary)
sensi_plot(samp_binary,graphs=1)
sensi_plot(samp_binary,graphs=2)
#Use a different evolutionary model or transformation 
samp_binary2<-samp_discrete(data = adultMass_binary,phy = primates$phy[[1]],
n.sim=25,breaks=seq(.1,.3,.1),model = "ARD",transform = "lambda",n.cores = 2,track = TRUE)
summary(samp_binary2)
sensi_plot(samp_binary2)
sensi_plot(samp_binary2,graphs=1)
sensi_plot(samp_binary2,graphs=3)
}
}
\references{
Paterno, G. B., Penone, C. Werner, G. D. A. 
\href{http://doi.wiley.com/10.1111/2041-210X.12990}{sensiPhy: 
An r-package for sensitivity analysis in phylogenetic 
comparative methods.} Methods in Ecology and Evolution 
2018, 9(6):1461-1467

Yang Z. 2006. Computational Molecular Evolution. Oxford University Press: Oxford. 

Harmon Luke J, Jason T Weir, Chad D Brock, Richard E Glor, and Wendell Challenger. 2008.
GEIGER: investigating evolutionary radiations. Bioinformatics 24:129-131.

Werner, G.D.A., Cornwell, W.K., Sprent, J.I., Kattge, J. & Kiers, E.T. (2014). 
A single evolutionary innovation drives the deep evolution of symbiotic N2-fixation in angiosperms. Nature Communications, 5, 4087.
}
\seealso{
\code{\link[geiger]{fitDiscrete}}
}
\author{
Gijsbert Werner & Gustavo Paterno
}
