% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samp_continuous.R
\name{samp_continuous}
\alias{samp_continuous}
\title{Species Sampling uncertainty - Trait Evolution Continuous Characters}
\usage{
samp_continuous(data, phy, n.sim = 30, breaks = seq(0.1, 0.5, 0.1), model,
  n.cores = NULL, bounds = list(), track = TRUE, ...)
}
\arguments{
\item{data}{Data vector for a single binary trait, with names matching tips in \code{phy}.}

\item{phy}{A phylogeny (class 'phylo') matching \code{data}.}

\item{n.sim}{The number of times species are randomly deleted for each \code{break}.}

\item{breaks}{A vector containing the percentages of species to remove.}

\item{model}{The evolutionary model (see Details).}

\item{n.cores}{number of cores to use. If 'NULL', number of cores is detected.}

\item{bounds}{settings to contstrain parameter estimates. See \code{\link[geiger]{fitContinuous}}}

\item{track}{Print a report tracking function progress (default = TRUE)}

\item{...}{Further arguments to be passed to \code{\link[geiger]{fitContinuous}}}
}
\value{
The function \code{tree_continuous} returns a list with the following
components:

\code{call}: The function call

\code{data}: The original full data vector

\code{optpar}: Transformation parameter used (e.g. \code{lambda}, \code{kappa} etc.)

\code{full.model.estimates}: Parameter estimates (rate of evolution \code{sigsq}
and where applicable \code{optpar}), root state \code{z0}, 
AICc for the full model without deleted species.

\code{break.summary.tab}: Summary per \code{break} of the mean and median effects 
of species removal on percentage and absolute change parameter estimates.

\code{sensi.estimates}: Parameter estimates (sigsq and optpar),(percentual) difference 
in parameter estimate compared to the full model (DIFsigsq, sigsq.perc,sDIFsigsq, 
DIFoptpar, optpar.perc,sDIFoptpar), 
AICc and z0 for each repeat with random species removed.

\code{optpar}: Transformation parameter used (e.g. \code{lambda}, \code{kappa} etc.)
}
\description{
Fits models for trait evolution of continuous characters, 
evaluating sampling uncertainty.
}
\details{
This function randomly removes a given percentage of species (controlled by \code{breaks}),  
fits different models of continuous character evolution using \code{\link[geiger]{fitContinuous}}, 
repeats this this many times (controlled by \code{n.sim}), stores the results and calculates 
the effects on model parameters.

Different evolutionary models from \code{fitContinuous} can be used, i.e. \code{BM},\code{OU},
\code{EB}, \code{trend}, \code{lambda}, \code{kappa}, \code{delta} and \code{drift}.

See \code{\link[geiger]{fitContinuous}} for more details on character models and tree transformations. 

Output can be visualised using \code{sensi_plot}.
}
\examples{
\dontshow{
#Load data:
data("primates")
#Model trait evolution accounting for phylogenetic uncertainty
adultMass<-primates$data$adultMass
names(adultMass)<-rownames(primates$data)
samp_cont<-samp_continuous(data = adultMass,phy = primates$phy[[1]],
model = "BM",n.sim=1,breaks=c(.1,.2),n.cores = 2, track = TRUE)
}
\dontrun{
#Load data:
data("primates")
#Model trait evolution accounting for sampling size 
adultMass<-primates$data$adultMass
names(adultMass)<-rownames(primates$data)
samp_cont<-samp_continuous(data = adultMass,phy = primates$phy[[1]],
model = "OU",n.sim=25,breaks=seq(.05,.2,.05),n.cores = 2, track = TRUE)
#Print summary statistics
summary(samp_cont)
sensi_plot(samp_cont)
sensi_plot(samp_cont, graphs = 1)
#Use a different evolutionary model 
samp_cont2<-samp_continuous(data = adultMass,phy = primates$phy[[1]],
model = "kappa",n.sim=25,breaks=seq(.05,.2,.05),n.cores = 2,track = TRUE)
summary(samp_cont2)
sensi_plot(samp_cont2)
sensi_plot(samp_cont2, graphs = 2)
samp_cont3<-samp_continuous(data = adultMass,phy = primates$phy[[1]],
model = "BM",n.sim=25,breaks=seq(.05,.2,.05),n.cores = 2,track = TRUE)
summary(samp_cont3)
}
}
\references{
Yang Z. 2006. Computational Molecular Evolution. Oxford University Press: Oxford. 

Harmon Luke J, Jason T Weir, Chad D Brock, Richard E Glor, and Wendell Challenger. 2008.
GEIGER: investigating evolutionary radiations. Bioinformatics 24:129-131.

Werner, G.D.A., Cornwell, W.K., Sprent, J.I., Kattge, J. & Kiers, E.T. (2014). 
A single evolutionary innovation drives the deep evolution of symbiotic N2-fixation in angiosperms. Nature Communications, 5, 4087.
}
\seealso{
\code{\link[geiger]{fitContinuous}}
}
\author{
Gijsbert Werner & Gustavo Paterno
}
