% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presenter.R
\name{presenter}
\alias{presenter}
\alias{semnar_presenter}
\title{Create a \code{semnar_presenter()} object with presenter details}
\usage{
presenter(
  name = NA,
  midname = NA,
  surname = NA,
  affiliation = NA,
  link = NA,
  email = NA,
  address = NA
)
}
\arguments{
\item{name}{name of the presenter; character string or \code{NA} (default).}

\item{midname}{middle name of the presenter; character string or \code{NA} (default).}

\item{surname}{surname of the presenter; character string or \code{NA} (default).}

\item{affiliation}{affiliation of the presenter; character string or \code{NA} (default).}

\item{link}{link to the webpage of the presenter; character string or \code{NA} (default).}

\item{email}{email of the presenter; character string or \code{NA} (default).}

\item{address}{address of the presenter; character string or \code{NA} (default).}
}
\value{
A structured \code{\link[=data.frame]{data.frame()}} that also inherits from class \code{\link{semnar_presenter}}, including the supplied presenter details.
}
\description{
Create a \code{semnar_presenter()} object with presenter details
}
\examples{
# A past talk of mine
ik_warwick <- presenter(name = "Ioannis", surname = "Kosmidis",
                        affiliation = "University of Warwick", link = "https://www.ikosmidis.com")
out <- add_presentation(country = "England", city = "Coventry",
                        lon = -1.560843, lat = 52.384019,
                        event = "Young Researchers' Meeting",
                        title = "A workflow that most probably isn't yours",
                        presenter = ik_warwick,
                        link = "https://warwick.ac.uk/fac/sci/statistics/news/yrm/",
                        type = "presentation", institution = "University of Warwick",
                        department = "Department of Statistics",
                        venue = "Mathematical Sciences Building", room = "M1.02",
                        year = 2019, month = 5, day = 28,
                        start_hour = 16, start_min = 00,
                        end_hour = 17, end_min = 00)
}
\seealso{
get_presenter set_presenter
}
