% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semmcci-methods.R
\name{coef.semmcci}
\alias{coef.semmcci}
\title{Parameter Estimates}
\usage{
\method{coef}{semmcci}(object, ...)
}
\arguments{
\item{object}{Object of class \code{semmcci}.}

\item{...}{additional arguments.}
}
\value{
Returns a vector of parameter estimates.
}
\description{
Parameter Estimates
}
\examples{
library(semmcci)
library(lavaan)

# Generate Data ------------------------------------------------------------
n <- 1000
a <- 0.50
b <- 0.50
cp <- 0.25
s2_em <- 1 - a^2
s2_ey <- 1 - cp^2 - a^2 * b^2 - b^2 * s2_em - 2 * cp * a * b
em <- rnorm(n = n, mean = 0, sd = sqrt(s2_em))
ey <- rnorm(n = n, mean = 0, sd = sqrt(s2_ey))
X <- rnorm(n = n)
M <- a * X + em
Y <- cp * X + b * M + ey
df <- data.frame(X, M, Y)

# Fit Model in lavaan ------------------------------------------------------
model <- "
  Y ~ cp * X + b * M
  M ~ a * X
  indirect := a * b
  direct := cp
  total := cp + (a * b)
"
fit <- sem(data = df, model = model)

# Monte Carlo --------------------------------------------------------------
unstd <- MC(
  fit,
  R = 100L, # use a large value e.g., 20000L for actual research
  alpha = c(0.001, 0.01, 0.05)
)
coef(unstd)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{method}
