% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_constructs.R
\name{constructs}
\alias{constructs}
\title{Measurement functions}
\usage{
constructs(...)
}
\arguments{
\item{...}{Comma separated list of the construct variable measurement specifications, as generated by the
\code{reflective()}, or \code{composite()} methods.}
}
\value{
A list of constructs, their indicators and estimation technique (SEMinR measurement model).
}
\description{
\code{constructs} creates the constructs from measurement items by assigning the
relevant items to each construct and specifying reflective or formative (composite/causal) measurement models
}
\details{
This function conveniently maps measurement items to constructs using
root name, numbers, and affixes with explicit definition of formative
or reflective relationships
}
\examples{
  mobi_mm <- constructs(
    reflective("Image",        multi_items("IMAG", 1:5)),
    reflective("Expectation",  multi_items("CUEX", 1:3)),
    reflective("Quality",      multi_items("PERQ", 1:7)),
    reflective("Value",        multi_items("PERV", 1:2)),
    reflective("Satisfaction", multi_items("CUSA", 1:3)),
    reflective("Complaints",   single_item("CUSCO")),
    reflective("Loyalty",      multi_items("CUSL", 1:3))
  )
}
\seealso{
See \code{\link{composite}}, \code{\link{reflective}}
}
