% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_relationships.R
\name{relationships}
\alias{relationships}
\alias{paths}
\title{Structural specification functions for seminr package}
\usage{
relationships(...)

paths(from,to)
}
\arguments{
\item{...}{A comma separated list of all the structural relationships in the the model. These
paths take the form (from = c(construct_name), to = c(construct_name)).}

\item{to}{The destination construct of a structural path}

\item{from}{The source construct of a structural path}

\item{paths}{The function \code{paths} that specifies the source and destination constructs
for each of the model's structural paths.}
}
\description{
\code{paths} creates the structural paths of a PLS SEM model and \code{relationships} generates
the matrix of paths.
}
\examples{
mobi_sm <- relationships(
  paths(from = "Image",        to = c("Expectation", "Satisfaction", "Loyalty")),
  paths(from = "Expectation",  to = c("Quality", "Value", "Satisfaction")),
  paths(from = "Quality",      to = c("Value", "Satisfaction")),
  paths(from = "Value",        to = c("Satisfaction")),
  paths(from = "Satisfaction", to = c("Complaints", "Loyalty")),
  paths(from = "Complaints",   to = "Loyalty")
)

}
