% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardizedSolution_boot_ci.R
\name{standardizedSolution_boot_ci}
\alias{standardizedSolution_boot_ci}
\title{Bootstrap CIs for Standardized
Solution}
\usage{
standardizedSolution_boot_ci(
  object,
  level = 0.95,
  type = "std.all",
  save_boot_est_std = TRUE,
  force_run = FALSE,
  boot_delta_ratio = FALSE,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{lavaan}
object, fitted with 'se = "boot"'.}

\item{level}{The level of confidence
of the confidence intervals. Default
is .95.}

\item{type}{The type of standard
estimates. The same argument of
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}},
and support all values supported by
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}.
Default is \code{"std.all"}.}

\item{save_boot_est_std}{Whether the
bootstrap estimates of the
standardized solution are saved. If
saved, they will be stored in the
attribute \code{boot_est_std}. Default is
\code{TRUE}.}

\item{force_run}{If \code{TRUE}, will skip
checks and run models without
checking the estimates. For internal
use. Default is \code{FALSE}.}

\item{boot_delta_ratio}{The ratio of
(a) the distance of the bootstrap
confidence limit from the point
estimate to (b) the distance of the
delta-method limit from the point
estimate.}

\item{...}{Other arguments to be
passed to
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}.}
}
\value{
The output of
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}},
with bootstrap confidence intervals
appended to the right.
}
\description{
It receives a
\link[lavaan:lavaan-class]{lavaan::lavaan} object fitted
with bootstrapping standard errors
requested and forms the confidence
intervals for the standardized
solution.

It works by calling
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}
with the bootstrap estimates
of free parameters in each bootstrap sample
to compute the standardized estimates
in each sample.

A more reliable way is to use
function like
\code{\link[lavaan:bootstrap]{lavaan::bootstrapLavaan()}}.
Nevertheless, this simple function is
good enough for some simple scenarios,
and does not require repeating
the bootstrapping step.
}
\examples{

library(lavaan)
set.seed(5478374)
n <- 50
x <- runif(n) - .5
m <- .40 * x + rnorm(n, 0, sqrt(1 - .40))
y <- .30 * m + rnorm(n, 0, sqrt(1 - .30))
dat <- data.frame(x = x, y = y, m = m)
model <-
'
m ~ a*x
y ~ b*m
ab := a*b
'

# Should set bootstrap to at least 2000 in real studies
fit <- sem(model, data = dat, fixed.x = FALSE,
           se = "boot",
           bootstrap = 100)
summary(fit)

standardizedSolution_boot_ci(fit)

}
\seealso{
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}
}
\author{
Shu Fai Cheung
\url{https://orcid.org/0000-0002-9871-9448}.
Originally proposed in an issue at GitHub
\url{https://github.com/simsem/semTools/issues/101#issue-1021974657},
inspired by a discussion at
the Google group for lavaan
\url{https://groups.google.com/g/lavaan/c/qQBXSz5cd0o/m/R8YT5HxNAgAJ}.
\code{\link[boot:boot.ci]{boot::boot.ci()}} is used to form the
percentile confidence intervals in
this version.
}
