% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_covariates.R
\name{calc_speed}
\alias{calc_speed}
\title{Calculate speed along a path}
\usage{
calc_speed(
  x,
  coord.names = c("x", "y"),
  timecol = "dateTime",
  smoothed = FALSE,
  units = "hour"
)
}
\arguments{
\item{x}{data.frame with locations}

\item{coord.names}{names of coordinates column in \code{x}}

\item{timecol}{names of POSIXct time column}

\item{smoothed}{whether speed are smoothed or not}

\item{units}{units for time calculation. Default "hour"}
}
\value{
vector of distance
}
\description{
\code{calc_dist} calculate speed between locations, taking a dataframe as
input. Speed can also be smoothed over the two steps before and after the
each point.
}
\examples{
\dontrun{calc_speed(df,coord.names = c("x","y"), timecol = "dateTime",
smoothed = T)}
}
\author{
Remi Patin
}
