% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LL_function.R
\name{LL_model}
\alias{LL_model}
\title{Analysis: Logistic regression}
\usage{
LL_model(
  trat,
  resp,
  npar = "LL.3",
  error = "SE",
  ylab = "Germination (\%)",
  xlab = expression("Temperature ("^"o" * "C)"),
  theme = theme_classic(),
  legend.position = "top",
  cardinal = 0,
  r2 = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  pointshape = 21,
  font.family = "sans"
)
}
\arguments{
\item{trat}{Numerical or complex vector with treatments}

\item{resp}{Numerical vector containing the response of the experiment.}

\item{npar}{Number of model parameters}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{Treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{Legend position (\emph{default} is c(0.3,0.8))}

\item{cardinal}{Defines the value of y considered extreme (\emph{default} considers 0 germination)}

\item{r2}{Coefficient of determination of the mean or all values (\emph{default} is all)}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{pointshape}{format point (\emph{default} is 21)}

\item{font.family}{Font family (\emph{default} is sans)}
}
\value{
\describe{
  \item{\code{Coefficients}}{Coefficients and their p values}
  \item{\code{Optimum temperature}}{Optimum temperature (equivalent to the maximum point)}
  \item{\code{Optimum temperature response}}{Response at the optimal temperature (equivalent to the maximum point)}
  \item{\code{Minimal temperature}}{Temperature that has the lowest response}
  \item{\code{Minimal temperature response}}{Lowest predicted response}
  \item{\code{Predicted maximum basal value}}{Lower basal limit temperature based on the value set by the user (default is 0)}
  \item{\code{Predicted minimum basal value}}{Upper basal limit temperature based on the value set by the user (default is 0)}
  \item{\code{AIC}}{Akaike information criterion}
  \item{\code{BIC}}{Bayesian Inference Criterion}
  \item{\code{r-squared}}{Determination coefficient}
  \item{\code{RMSE}}{Root mean square error}
  \item{\code{grafico}}{Graph in ggplot2 with equation}
  }
}
\description{
Logistic models with three (LL.3) or four (LL.4) continuous data parameters. This model was extracted from the drc package and adapted for temperature analysis in seed germination.
}
\details{
The three-parameter log-logistic function with lower limit 0 is
\deqn{f(x) = 0 + \frac{d}{1+\exp(b(\log(x)-\log(e)))}}
The four-parameter log-logistic function is given by the expression
\deqn{f(x) = c + \frac{d-c}{1+\exp(b(\log(x)-\log(e)))}}
The function is symmetric about the inflection point (e).
}
\note{
if the maximum predicted value is equal to the maximum x, the curve does not have a maximum point within the studied range. If the minimum value is less than the lowest point studied, disregard the value.
}
\examples{
library(seedreg)
data("aristolochia")
attach(aristolochia)

#================================
# Germination
#================================
LL_model(trat,germ)

#================================
# Germination speed
#================================
LL_model(trat, vel, ylab=expression("v"~(dias^-1)))
}
\references{
Seber, G. A. F. and Wild, C. J (1989) Nonlinear Regression, New York: Wiley and Sons (p. 330).

Ritz, C.; Strebig, J.C.; Ritz, M.C. Package ‘drc’. Creative Commons: Mountain View, CA, USA, 2016.
}
\author{
Model imported from the drc package (Ritz et al., 2016)

Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
