% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_CART.R
\name{compare_cart}
\alias{compare_cart}
\title{Compare the synthetic data generated by CART with the real data.}
\usage{
compare_cart(training_set, fit_model, var_list)
}
\arguments{
\item{training_set}{A data frame of the training data. The generated data will
have the same size as the \code{training_set}.}

\item{fit_model}{A \code{\link[synthpop:syn]{syn}}) object.}

\item{var_list}{A string vector of the names of variables that we want to compare.}
}
\value{
A plot of the comparision of the distribution of
    synthetic data vs real data.
}
\description{
\code{compare_cart} compare the synthetic data generated by CART with the real data.
}
\examples{
adult_data <- split_data(adult[1:100,], 70)
cart <- gen_cart(adult_data$training_set)
compare_cart(adult_data$training_set, cart$fit_model, c("age", "workclass", "sex"))

}
