% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\docType{methods}
\name{report}
\alias{report}
\title{Generate an Html-report from an sdcMicroObj}
\usage{
report(
  obj,
  outdir = tempdir(),
  filename = "SDC-Report",
  title = "SDC-Report",
  internal = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{obj}{an object of class \code{\link{sdcMicroObj-class}} or \code{reportObj}}

\item{outdir}{output folder}

\item{filename}{output filename}

\item{title}{Title for the report}

\item{internal}{TRUE/FALSE, if TRUE a detailed internal report is produced,
else a non-disclosive overview}

\item{verbose}{TRUE/FALSE, if TRUE, some additional information is printed.}
}
\description{
Summary statistics of the original and the perturbed data set
}
\details{
The application of this function provides you with a html-report for your
sdcMicro object that contains useful summaries about the anonymization process.
}
\examples{
\donttest{
data(testdata2)
sdc <- createSdcObj(
  dat = testdata2,
  keyVars = c("urbrur", "roof", "walls", "water", "electcon", "relat", "sex"),
  numVars = c("expend", "income", "savings"),
  w = "sampling_weight"
)
report(sdc)
}
}
\author{
Matthias Templ, Bernhard Meindl
}
\keyword{methods}
