% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqCalc.r
\name{freqCalc}
\alias{freqCalc}
\title{Frequencies calculation for risk estimation}
\usage{
freqCalc(x, keyVars, w = NULL, alpha = 1)
}
\arguments{
\item{x}{data frame or matrix}

\item{keyVars}{key variables}

\item{w}{column index of the weight variable. Should be set to NULL if one
deal with a population.}

\item{alpha}{numeric value between 0 and 1 specifying how much keys that
contain missing values (\code{NAs}) should contribute to the calculation
of \code{fk} and \code{Fk}. For the default value of \code{1}, nothing changes with
respect to the implementation in prior versions. Each \emph{wildcard-match} would
be counted while for \code{alpha=0} keys with missing values would be basically ignored.}
}
\value{
Object from class freqCalc.
\item{freqCalc}{data set}
\item{keyVars}{variables used for frequency calculation}
\item{w}{index of weight vector. NULL if you do not have a sample.}
\item{alpha}{value of parameter \code{alpha}}
\item{fk}{the frequency of equal observations in
the key variables subset sample given for each observation.}
\item{Fk}{estimated frequency in the population}
\item{n1}{number of observations with fk=1}
\item{n2}{number of observations with fk=2}
}
\description{
Computation and estimation of the sample and population frequency counts.
}
\details{
The function considers the case of missing values in the data.  A missing
value stands for any of the possible categories of the variable considered.
It is possible to apply this function to large data sets with many
(catergorical) key variables, since the computation is done in C.

\emph{freqCalc()} does not support sdcMicro S4 class objects.
}
\examples{

data(francdat)
f <- freqCalc(francdat, keyVars=c(2,4,5,6),w=8)
f
f$freqCalc
f$fk
f$Fk
## with missings:
x <- francdat
x[3,5] <- NA
x[4,2] <- x[4,4] <- NA
x[5,6]  <- NA
x[6,2]  <- NA
f2 <- freqCalc(x, keyVars=c(2,4,5,6),w=8)
cbind(f2$fk, f2$Fk)

## test parameter 'alpha'
f3a <- freqCalc(x, keyVars=c(2,4,5,6), w=8, alpha=1)
f3b <- freqCalc(x, keyVars=c(2,4,5,6), w=8, alpha=0.5)
f3c <- freqCalc(x, keyVars=c(2,4,5,6), w=8, alpha=0.1)
data.frame(fka=f3a$fk, fkb=f3b$fk, fkc=f3c$fk)
data.frame(Fka=f3a$Fk, Fkb=f3b$Fk, Fkc=f3c$Fk)
}
\author{
Bernhard Meindl
}
\references{
look e.g. in \url{http://neon.vb.cbs.nl/casc/Deliv/12d1.pdf}
Templ, M.  \emph{Statistical Disclosure Control for Microdata Using the
R-Package sdcMicro}, Transactions on Data Privacy, vol. 1, number 2, pp.
67-85, 2008.  \url{http://www.tdp.cat/issues/abs.a004a08.php}

Templ, M.  \emph{New Developments in Statistical Disclosure Control and
Imputation: Robust Statistics Applied to Official Statistics},
Suedwestdeutscher Verlag fuer Hochschulschriften, 2009, ISBN: 3838108280,
264 pages.

Templ, M. and Meindl, B.: \emph{Practical Applications in Statistical
Disclosure Control Using R}, Privacy and Anonymity in Information Management
Systems New Techniques for New Practical Problems, Springer, 31-62, 2010,
ISBN: 978-1-84996-237-7.
}
\seealso{
\code{\link{indivRisk}}, \code{\link{measure_risk}}
}
\keyword{manip}

