% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_func.R
\name{saveat_func}
\alias{saveat_func}
\title{Internal function to save data frame at specific times}
\usage{
saveat_func(df, time_col, new_times)
}
\arguments{
\item{df}{data.frame in wide format}

\item{time_col}{Name of the time column}

\item{new_times}{Vector of new times to save the data frame at}
}
\value{
Interpolated data.frame. The data frame has columns \code{time} followed by
one column per variable.
}
\description{
Internal function used to save the data frame at specific times in case save_at is not equal to dt in the simulation specifications.
}
\examples{
# Recommended: Use save_at in sim_specs() to downsample simulations
sfm <- xmile("SIR") |> sim_specs(dt = 0.01, save_at = 1)
sim <- simulate(sfm)
df <- as.data.frame(sim)
nrow(df) # Returns only times at intervals of 1
head(df)

# The saveat_func() is the underlying function used by simulate()
# Direct use is not recommended, but shown here for completeness:
sfm <- sfm |> sim_specs(save_at = 0.01)
sim <- simulate(sfm)
df <- as.data.frame(sim)
nrow(df) # Many more rows

# Manual downsampling (not recommended - use save_at instead)
new_times <- seq(min(df$time), max(df$time), by = 1)
df_wide <- as.data.frame(sim, direction = "wide")
df_manual <- saveat_func(df_wide, "time", new_times)
nrow(df_manual)

}
\concept{internal}
