% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{clean_name}
\alias{clean_name}
\title{Clean variable name(s)}
\usage{
clean_name(new, existing, protected = c())
}
\arguments{
\item{new}{Vector of names to transform to valid names}

\item{existing}{Vector of existing names in model}

\item{protected}{Optional vector of protected names}
}
\value{
Vector of cleaned names
}
\description{
Clean variable name(s) to create syntactically valid, unique names for use in R and Julia.
}
\examples{
sfm <- xmile("predator_prey")
# As the variable name "predator" is already taken, clean_name() will create
# an unique name
clean_name("predator", as.data.frame(sfm)[["name"]]) # "predator_1"

}
\concept{internal}
