% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast-unit.R
\name{set_forecast_unit}
\alias{set_forecast_unit}
\title{Set unit of a single forecast manually}
\usage{
set_forecast_unit(data, forecast_unit)
}
\arguments{
\item{data}{A data.frame (or similar) with predicted and observed values.
See the details section of for additional information
on the required input format.}

\item{forecast_unit}{Character vector with the names of the columns that
uniquely identify a single forecast.}
}
\value{
A data.table with only those columns kept that are relevant to
scoring or denote the unit of a single forecast as specified by the user.
}
\description{
Helper function to set the unit of a single forecast (i.e. the
combination of columns that uniquely define a single forecast) manually.
This simple function keeps the columns specified in \code{forecast_unit} (plus
additional protected columns, e.g. for observed values, predictions or
quantile levels) and removes duplicate rows. \code{set_forecast_unit()} will
mainly be called when constructing a \code{forecast} object
via the \code{forecast_unit} argument in \verb{as_forecast_<type>}.

If not done explicitly, \code{scoringutils} attempts to determine the unit
of a single forecast automatically by simply assuming that all column names
are relevant to determine the forecast unit. This may lead to unexpected
behaviour, so setting the forecast unit explicitly can help make the code
easier to debug and easier to read.
}
\examples{
library(magrittr) # pipe operator
example_quantile \%>\%
  scoringutils:::set_forecast_unit(
    c("location", "target_end_date", "target_type", "horizon", "model")
  )
}
\keyword{as_forecast}
