% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-forecasts.R
\name{log_shift}
\alias{log_shift}
\title{Log transformation with an additive shift}
\usage{
log_shift(x, offset = 0, base = exp(1))
}
\arguments{
\item{x}{vector of input values to be transformed}

\item{offset}{Number to add to the input value before taking the natural
logarithm.}

\item{base}{A positive number: the base with respect to which
logarithms are computed. Defaults to e = exp(1).}
}
\value{
A numeric vector with transformed values
}
\description{
Function that shifts a value by some offset and then applies the
natural logarithm to it.
}
\details{
The output is computed as log(x + offset)
}
\examples{
library(magrittr) # pipe operator
log_shift(1:10)
log_shift(0:9, offset = 1)

example_quantile[observed > 0, ] \%>\%
  as_forecast_quantile() \%>\%
  transform_forecasts(fun = log_shift, offset = 1)
}
\references{
Transformation of forecasts for evaluating predictive
performance in an epidemiological context
Nikos I. Bosse, Sam Abbott, Anne Cori, Edwin van Leeuwen, Johannes Bracher,
Sebastian Funk
medRxiv 2023.01.23.23284722
\doi{https://doi.org/10.1101/2023.01.23.23284722}
\url{https://www.medrxiv.org/content/10.1101/2023.01.23.23284722v1} # nolint
}
\keyword{transform}
