% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{schwab_transactSearch}
\alias{schwab_transactSearch}
\title{Search for all Transaction types}
\usage{
schwab_transactSearch(
  account_number,
  startDate = Sys.Date() - 30,
  endDate = Sys.Date(),
  transType = "TRADE",
  accessTokenList = NULL
)
}
\arguments{
\item{account_number}{A Schwab account number associated with the Access Token}

\item{startDate}{Transactions after a certain date. Will not pull back
transactions older than 1 year. format yyyy-mm-dd}

\item{endDate}{Filter transactions that occurred before a certain date.
format yyyy-mm-dd}

\item{transType}{Filter for a specific Transaction type. No entry will return
all types. For example: TRADE, CASH_IN_OR_CASH_OUT, CHECKING, DIVIDEND,
INTEREST, OTHER}

\item{accessTokenList}{A valid Access Token must be set using the output from
\code{\link{schwab_auth3_accessToken}}. The most recent Access Token will be
used by default unless one is manually passed into the function.}
}
\value{
a jsonlite data frame of transactions
}
\description{
Can pull trades as well as transfers, dividend reinvestment, interest, etc.
Any activity associated with the account.
}
\examples{
\dontrun{

# Access Token must be set using schwab_auth_accessToken
# Transactions for the last 5 days
schwab_transactSearch(account_number = 987654321,
                startDate = Sys.Date()-days(5))

}
}
