% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterPlotMatrix.R
\name{scatterPlotMatrix}
\alias{scatterPlotMatrix}
\title{htmlwidget for d3.js scatter plot matrix}
\usage{
scatterPlotMatrix(
  data,
  controlWidgets = FALSE,
  categorical = NULL,
  inputColumns = NULL,
  keptColumns = NULL,
  zAxisDim = NULL,
  distribType = 2,
  regressionType = 0,
  corrPlotType = "Circles",
  corrPlotCS = "Plasma",
  rotateTitle = FALSE,
  columnLabels = NULL,
  continuousCS = "Viridis",
  categoricalCS = "Category10",
  eventInputId = NULL,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{data.frame with data to use in the chart.}

\item{controlWidgets}{Tells if some widgets must be available to control plot; 
\code{NULL} is allowed, meaning that '!HTMLWidgets.shinyMode' is to use; 
default value is \code{FALSE}.}

\item{categorical}{List of list (one for each data column) containing the name of available categories, 
or \code{NULL} if column corresponds to continuous data; 
\code{NULL} is allowed, meaning all columns are continuous.}

\item{inputColumns}{List of boolean (one for each data column), \code{TRUE} for an input column, \code{FALSE} for an output column; 
\code{NULL} is allowed, meaning all columns are inputs.}

\item{keptColumns}{List of boolean (one for each data column), \code{FALSE} if column has to be ignored; 
\code{NULL} is allowed, meaning all columns are available.}

\item{zAxisDim}{Name of the column represented by z axis (used to determine the color to attribute to a point); 
\code{NULL} is allowed, meaning there is no coloring to apply.}

\item{distribType}{Binary code indicating the type of distribution plot (bit 1: density plot, bit 2: histogram).}

\item{regressionType}{Binary code indicating the type of regression plot (bit 1: linear, bit 2: loess).}

\item{corrPlotType}{String indicating the type of correlation plots to use;
supported values: \code{Circles} to use a circle tree map, \code{Text} to use simple text labels; 
default value is \code{Circles}.}

\item{corrPlotCS}{Name of the color Scale to use for correlation plot when plot type is 'Text';
supported names: "Viridis", "Inferno", "Magma", "Plasma", "Warm", "Cool", "Rainbow", "CubehelixDefault", 
"Blues","Greens", "Greys", "Oranges", "Purples", "Reds", "BuGn", "BuPu", "GnBu", "OrRd", "PuBuGn","PuBu", 
"PuRd", "RdBu", "RdPu", "YlGnBu", "YlGn", "YlOrBr", "YlOrRd"; 
default value is \code{Plasma}.}

\item{rotateTitle}{\code{TRUE} if column title must be rotated.}

\item{columnLabels}{List of string (one for each data column) to display in place of column name found in data, 
or \code{NULL} if there is no alternative name; 
\code{NULL} is allowed, meaning all columns are without alternative name; 
\code{<br>} can be used to insert line breaks.}

\item{continuousCS}{Name of the color Scale to use for continuous data;
supported names: "Viridis", "Inferno", "Magma", "Plasma", "Warm", "Cool", "Rainbow", "CubehelixDefault", 
"Blues","Greens", "Greys", "Oranges", "Purples", "Reds", "BuGn", "BuPu", "GnBu", "OrRd", "PuBuGn","PuBu", 
"PuRd", "RdBu", "RdPu", "YlGnBu", "YlGn", "YlOrBr", "YlOrRd"; 
default value is \code{Viridis}.}

\item{categoricalCS}{Name of the color Scale to use for categorical data; 
supported names: Category10, Accent, Dark2, Paired, Set1; 
default value is \code{Category10}.}

\item{eventInputId}{When plot event occured, reactive input to write to; \code{NULL} is allowed, default value is 'plotEvent'.}

\item{width}{Integer in pixels defining the width of the widget.}

\item{height}{Integer in pixels defining the height of the widget.}

\item{elementId}{Unique \code{CSS} selector id for the widget.}
}
\description{
htmlwidget for d3.js scatter plot matrix
}
\examples{
 if(interactive()) {
   library(scatterPlotMatrix)

   scatterPlotMatrix(iris, zAxisDim = "Species")
   # Each point has a color depending of its 'Species' value

   categorical <- list(NULL, c(4, 6, 8), NULL, NULL, NULL, NULL, NULL, c(0, 1), c(0, 1), 3:5, 1:8)
   scatterPlotMatrix(mtcars, categorical = categorical, zAxisDim = "cyl")
   # 'cyl' and four last columns have a box representation for its categories
   # (use top slider to see the last three columns)

   scatterPlotMatrix(iris, zAxisDim = "Species", distribType = 1)
   # Distribution plots are of type 'density plot' (instead of histogram)

   scatterPlotMatrix(iris, zAxisDim = "Species", regressionType = 1)
   # Add linear regression plots

   columnLabels <- gsub("\\\\.", "<br>", colnames(iris))
   scatterPlotMatrix(iris, zAxisDim = "Species", columnLabels = columnLabels)
   # Given names are displayed in place of dataset column names; <br> is used to insert line breaks
 }

}
