% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIGER_Utilities.R
\name{Cells_by_Identities_LIGER}
\alias{Cells_by_Identities_LIGER}
\title{Extract Cells by identity}
\usage{
Cells_by_Identities_LIGER(liger_object, group.by = NULL, by_dataset = FALSE)
}
\arguments{
\item{liger_object}{LIGER object name.}

\item{group.by}{name of meta data column to use, default is current default clustering.}

\item{by_dataset}{logical, whether to return list with entries for cell barcodes for each
identity in \code{group.by}
or to return list of lists (1 entry per dataset and each ident within the dataset)
(default is FALSE; return list)}
}
\value{
list or list of lists depending on \code{by_dataset} parameter
}
\description{
Extract all cell barcodes by identity from LIGER object
}
\examples{
\dontrun{
# return single vector of all cells
cells_by_idents <- Cells_by_Identities_LIGER(liger_object = object, by_dataset = FALSE)

# return list of vectors containing cells from each individual dataset in object
cells_by_idents_by_dataset <- Cells_by_Identities_LIGER(liger_object = object, by_dataset = TRUE)
}

}
\concept{liger_object_util}
