% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_&_Write_Data.R
\name{Read10X_h5_GEO}
\alias{Read10X_h5_GEO}
\title{Load in NCBI GEO data from 10X in HDF5 file format}
\usage{
Read10X_h5_GEO(
  data_dir = NULL,
  sample_list = NULL,
  sample_names = NULL,
  shared_suffix = NULL,
  parallel = FALSE,
  num_cores = NULL,
  merge = FALSE,
  ...
)
}
\arguments{
\item{data_dir}{Directory containing the .h5 files provided by 10X.}

\item{sample_list}{A vector of file prefixes/names if specific samples are desired.  Default is \code{NULL} and
will load all samples in given directory.}

\item{sample_names}{a set of sample names to use for each sample entry in returned list.  If \code{NULL}
will set names to the file name of each sample.}

\item{shared_suffix}{a suffix and file extension shared by all samples.}

\item{parallel}{logical (default FALSE).  Whether to use multiple cores when reading in data.
Only possible on Linux based systems.}

\item{num_cores}{if \code{parallel = TRUE} indicates the number of cores to use for multicore processing.}

\item{merge}{logical (default FALSE) whether or not to merge samples into a single matrix or return
list of matrices.  If TRUE each sample entry in list will have cell barcode prefix added.  The prefix
will be taken from \code{sample_names}.}

\item{...}{Additional arguments passed to \code{\link[Seurat]{Read10X_h5}}}
}
\value{
If the data has multiple data types, a list
containing a sparse matrix of the data from each type will be returned.
Otherwise a sparse matrix containing the expression data will be returned.
}
\description{
Enables easy loading of HDF5 data matrices provided by 10X genomics. That have file prefixes added to
them by NCBI GEO or other repos or programs (i.e. Cell Bender)
}
\examples{
\dontrun{
data_dir <- 'path/to/data/directory'
expression_matrices <- Read10X_h5_GEO(data_dir = data_dir)
# To create object from single file
seurat_object = CreateSeuratObject(counts = expression_matrices[[1]])
}

}
\concept{read_&_write}
