% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lutInfo.R
\name{lutInfo}
\alias{lutInfo}
\alias{lutInfoBandsFromSID}
\alias{lutInfoSensorFromSID}
\alias{lutInfoBCDEFromBID}
\alias{lutInfoBIDFromBCDE}
\alias{lutInfoRSRromSID}
\alias{lutInfoSIDfromFilename}
\alias{lutInfoSGRPfromFilename}
\title{Get or access internal LUT values used by various functions}
\usage{
lutInfo()

lutInfoBandsFromSID(sid)

lutInfoSensorFromSID(sid)

lutInfoBCDEFromBID(sid, bid)

lutInfoBIDFromBCDE(bcde, sid)

lutInfoRSRromSID(sid)

lutInfoSIDfromFilename(files)

lutInfoSGRPfromFilename(file)
}
\arguments{
\item{sid}{Sensor id as returned e.g. from \code{\link{lutInfoSensorFromSID}}.}

\item{bid}{Band id as returned e.g. from \code{\link{lutInfoBIDFromBCDE}}.}

\item{bcde}{Band code as returned e.g. from \code{\link{lutInfoBCDEFromBID}}.}

\item{files}{Filename (or filepath) of one or more remote sensing data 
filenames}

\item{file}{Filename of a remote sensing data file}
}
\value{
List containing several \code{data.frame} objects with LUT values.
}
\description{
Get internal look-up table (LUT) values from sysdata.rda which have been 
compiled using data-raw/lut_data.R. Metadata is stored in \code{lut$meta}.
}
\details{
The functions above return the following information:
\itemize{
  \item \code{lutInfoBandsFromSID} returns the band info block.
  \item \code{lutInfoBCDEFromBID} returns the band code.
  \item \code{lutInfoBIDFromBCDE} returns the band ids.
  \item \code{lutInfoRSRromSID} returns the relative spectral response (rsr) 
        for the sensor.
  \item \code{lutInfoSensorFromSID} returns the sensor name.
}

The LUT contains the following information:
\describe{
  \item{l4_band_wl}{Minimum/maximum wavelength for Landsat 4 bands taken from the
\href{http://landsat.usgs.gov/band_designations_landsat_satellites.php}{band info}
of the USGS Landsat FAQ.}
  \item{l5_band_wl}{Minimum/maximum wavelength for Landsat 5 bands taken from the
\href{http://landsat.usgs.gov/band_designations_landsat_satellites.php}{band info}
of the USGS Landsat FAQ.}
  \item{l7_band_wl}{Minimum/maximum wavelength for Landsat 7 bands taken from the
\href{http://landsat.usgs.gov/band_designations_landsat_satellites.php}{band info}
of the USGS Landsat FAQ.}
\item{l8_band_wl}{Minimum/maximum wavelength for Landsat 8 bands taken from the
\href{http://landsat.usgs.gov/band_designations_landsat_satellites.php}{band info}
of the USGS Landsat FAQ.}
\item{l7_rsr}{Landat 7 rsr (nm-1) taken from taken from the
\href{http://landsat.usgs.gov/instructions.php}{spectral viewer}
of the USGS Landsat FAQ.}
\item{l8_rsr}{Landat 8 rsr (nm-1) taken from taken from the
\href{http://landsat.usgs.gov/instructions.php}{spectral viewer}
of the USGS Landsat FAQ.}
\item{solar}{Solar irradiance (W m-2 nm-1) taken from the 
\href{http://rredc.nrel.gov/solar/spectra/am0/modtran.html}{National Renewable 
Energy Laboratory}.}
\item{l7_esun}{Tabulated ESun values from 
\href{https://landsat.gsfc.nasa.gov/wp-content/uploads/2016/08/Landsat7_Handbook.pdf}{tab 11.3 (Thuillier spectrum)}
 of the Landsat7 handbook.}
\item{l5_esun, l4_esun}{Tabulated ESun values from 
\href{ftp://ftp.vt.tpu.ru/study/Tokareva/public/English_prof/GIS/L5TMLUTIEEE2003.pdf}{Chander
G, Markham B (2003) Revised Landsat-5 TM radiometric calibration procedures 
and postcalibration dynamic ranges. IEEE Transaction on Geoscience and 
Remote Sensing 41/11, doi:10.1109/LGRS.2007.898285}.}
}
}
\section{Functions}{
\itemize{
\item \code{lutInfoBandsFromSID}: 

\item \code{lutInfoSensorFromSID}: 

\item \code{lutInfoBCDEFromBID}: 

\item \code{lutInfoBIDFromBCDE}: 

\item \code{lutInfoRSRromSID}: 

\item \code{lutInfoSIDfromFilename}: 

\item \code{lutInfoSGRPfromFilename}: 
}}

\examples{
ls_li <- lutInfo()
# str(ls_li)

}
