% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posneg_words.R
\name{posneg_words}
\alias{posneg_words}
\title{Twitter Positive and Negative Words}
\usage{
posneg_words(DataFrameTidy, num_words, filterword = NULL)
}
\arguments{
\item{DataFrameTidy}{DataFrame of Twitter Data that has been tidy'd.}

\item{num_words}{Desired number of words to be returned.}

\item{filterword}{Word or words to be removed}
}
\value{
A ggplot
}
\description{
Determines and displays the most positive and negative words within the twitter data.
}
\examples{
\donttest{
library(saotd)
data <- raw_tweets
tidy_data <- Tidy(DataFrame = data)
posneg <- posneg_words(DataFrameTidy = tidy_data,
                       n = 10)
posneg
                          
data <- raw_tweets
tidy_data <- Tidy(DataFrame = data)
posneg <- posneg_words(DataFrameTidy = tidy_data,
                       n = 10,
                       filterword = "fail")
posneg
                          
data <- raw_tweets
tidy_data <- Tidy(DataFrame = data)
posneg <- posneg_words(DataFrameTidy = tidy_data,
                       n = 10,
                       filterword = c("fail", "urgent"))            
posneg
}
}
