% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/salt_delete.R
\name{salt_delete}
\alias{salt_delete}
\title{Delete some characters from some values}
\usage{
salt_delete(x, p = 0.2, n = 1)
}
\arguments{
\item{x}{A vector. This will always be coerced to character during salting.}

\item{p}{A number between 0 and 1. Percent of values in \code{x} that should be
salted.}

\item{n}{A positive integer. Number of times to add new values from
\code{insertions} into selected values in \code{x} manually supply your own list of
characters.}
}
\value{
A character vector the same length as \code{x}
}
\description{
Delete some characters from some values
}
\examples{
x <- c("Lorem ipsum dolor sit amet, consectetur adipiscing elit.",
       "Nunc finibus tortor a elit eleifend interdum.",
       "Maecenas aliquam augue sit amet ultricies placerat.")

salt_delete(x, p = 0.5, n = 5)

salt_empty(x, p = 0.5)

salt_na(x, p = 0.5)
}
