% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-metadata.R
\name{collapse_list_with_dupe_names}
\alias{collapse_list_with_dupe_names}
\title{Collapse Elements in List with Same Name}
\usage{
collapse_list_with_dupe_names(x)
}
\arguments{
\item{x}{list; a list, typically returned from the API that we would parse through}
}
\value{
A \code{list} containing one row per field for the requested object.
}
\description{
This function looks for instances of elements in a list that have the same name
and then combine them all into a single comma separated character string
(referenceTo) or \code{tbl_df} (picklistValues).
}
\note{
The tibble only contains the fields that the user can view, as defined by
the user's field-level security settings.
}
\examples{
\dontrun{
obj_dat <- sf_describe_objects(object_names = "Contact", api_type = "SOAP")[[1]]
obj_fields_list <- obj_dat[names(obj_dat) == "fields"] \%>\% 
  map(collapse_list_with_dupe_names)
}
}
