% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-org.R
\name{sf_find_duplicates_by_id}
\alias{sf_find_duplicates_by_id}
\title{Find Duplicate Records By Id}
\usage{
sf_find_duplicates_by_id(
  sf_id,
  include_record_details = FALSE,
  guess_types = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{sf_id}{character; a Salesforce generated Id that identifies a record}

\item{include_record_details}{logical; get fields and values for records detected 
as duplicates by setting this property to \code{TRUE}. Get only record IDs for 
records detected as duplicates by setting this property to \code{FALSE}}

\item{guess_types}{logical; indicating whether or not to use \code{col_guess()} 
to try and cast the data returned in the query recordset. TRUE uses \code{col_guess()} 
and FALSE returns all values as character strings.}

\item{verbose}{logical; do you want informative messages?}
}
\value{
\code{tbl_df} of records found to be duplicates by the match rules
}
\description{
Performs rule-based searches for duplicate records.
}
\note{
You must have actived duplicate rules for the supplied object before running 
this function. This function uses the duplicate rules for the object that has 
the same type as the input record IDs. For example, if the record Id represents 
an Account, this function uses the duplicate rules associated with the 
Account object.
}
\examples{
\dontrun{
# use the duplicate rules associated with the object that this record 
# belongs to in order to find duplicates
found_dupes <- sf_find_duplicates_by_id(sf_id = "00Q6A00000aABCnZZZ")
}
}
