% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_abort_job_bulk}
\alias{sf_abort_job_bulk}
\title{Abort Bulk API Job}
\usage{
sf_abort_job_bulk(job_id, api_type = c("Bulk 1.0", "Bulk 2.0"),
  verbose = FALSE)
}
\arguments{
\item{job_id}{character; the Salesforce Id assigned to a submitted job as 
returned by \link{sf_create_job_bulk}}

\item{api_type}{character; one of "REST", "SOAP", "Bulk 1.0", "Bulk 2.0", or 
"Chatter" indicating which API to use when making the request}

\item{verbose}{logical; do you want informative messages?}
}
\value{
A \code{list} of parameters defining the now aborted job
}
\description{
This function aborts a Job in the Salesforce Bulk API
}
\examples{
\dontrun{
job_info <- sf_create_job_bulk('insert', 'Account')
sf_abort_job_bulk(job_info$id)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
