% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-xml.R
\name{build_soap_xml_from_list}
\alias{build_soap_xml_from_list}
\title{Build XML Request Body}
\usage{
build_soap_xml_from_list(input_data, operation = c("create", "retrieve",
  "update", "upsert", "delete", "search", "query", "queryMore",
  "describeSObjects"), object_name = NULL, fields = NULL,
  external_id_fieldname = NULL, root_name = NULL, ns = c(character(0)),
  root = NULL)
}
\arguments{
\item{input_data}{a \code{data.frame} of data to fill the XML body}

\item{operation}{character; a string defining the type of operation being 
performed (e.g. "insert", "update", "upsert", "delete")}

\item{object_name}{character; the name of one Salesforce objects that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{fields}{character; one or more strings indicating the fields to be returned 
on the records}

\item{external_id_fieldname}{character; string identifying a custom field on the 
object that has been set as an "External ID" field. This field is used to reference 
objects during upserts to determine if the record already exists in Salesforce or not.}

\item{root_name}{character; the name of the root node if created}

\item{ns}{named vector; a collection of character strings indicating the namespace 
definitions of the root node if created}

\item{root}{\code{XMLNode}; a node to be used as the root}
}
\value{
a XML document
}
\description{
Parse data into XML format
}
\note{
This function is meant to be used internally. Only use when debugging.
}
\keyword{internal}
