% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.cv.sail}
\alias{plot.cv.sail}
\title{Plot the cross-validation curve produced by \code{cv.sail}}
\usage{
\method{plot}{cv.sail}(x, sign.lambda = 1, ...)
}
\arguments{
\item{x}{fitted \code{cv.sail} object}

\item{sign.lambda}{Either plot against \code{log(lambda)} (default) or its
negative if \code{sign.lambda=-1}.}

\item{...}{Other graphical parameters to plot}
}
\value{
A plot is produced and nothing is returned
}
\description{
Plots the cross-validation curve, and upper and lower standard
  deviation curves, as a function of the \code{lambda} values used.
}
\details{
This is a port of \code{plot.cv.glmnet}
}
\examples{
data("sailsim")
f.basis <- function(i) splines::bs(i, degree = 3)
library(doParallel)
cl <- makeCluster(2)
registerDoParallel(cl)
cvfit <- cv.sail(x = sailsim$x, y = sailsim$y, e = sailsim$e,
                 parallel = TRUE, nlambda = 10,
                 maxit = 100, basis = f.basis,
                 nfolds = 3, dfmax = 10)
stopCluster(cl)
plot(cvfit)
}
\references{
Jerome Friedman, Trevor Hastie, Robert Tibshirani (2010).
  Regularization Paths for Generalized Linear Models via Coordinate Descent.
  Journal of Statistical Software, 33(1), 1-22.
  \url{http://www.jstatsoft.org/v33/i01/}.
}
\seealso{
\code{\link{sail}}, \code{\link{cv.sail}}
}
