% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R
\name{encrypt_file}
\alias{encrypt_file}
\title{Encrypt a file}
\usage{
encrypt_file(infile, key = "pass", pkey = NULL, ascii = FALSE, outfile)
}
\arguments{
\item{infile}{file to be encrypted}

\item{key}{For symmetric encryption, 'pkey' should be NULL (default) and
'key' can be either a string (Default is 'pass') or a raw object. For
asymmetric encryption, both 'key' (private key of the encrypter) and 'pkey'
(public key of the decrypter) should be raw objects.}

\item{pkey}{See 'key'}

\item{ascii}{\code{TRUE} if the outfile is to be encrypted as a ascii file.
Default is \code{FALSE}}

\item{outfile}{Non-existant file where the encrypted output is to be written}
}
\value{
An invisible TRUE
}
\description{
\code{encrypt_file}) encrypts a file as a binary or a ascii
  file. \code{decrypt_file}) decrypts a text or a binary file (encrypted by
  \code{encrypt_file})
}
\examples{
# symmetric case:
write.table(iris, "iris.csv")
all(
  encrypt_file("iris.csv", outfile = "iris_encrypted.bin")
  , file.exists("iris_encrypted.bin")
  , decrypt_file("iris_encrypted.bin", outfile = "iris_2.csv")
  , file.exists("iris_2.csv")
  , tools::md5sum("iris_2.csv") == tools::md5sum("iris.csv")
  , unlink("iris.csv") == 0
  , unlink("iris_2.csv") == 0
  , unlink("iris_encrypted.bin") == 0
)

write.table(iris, "iris.csv")
all(
  encrypt_file("iris.csv", outfile = "iris_encrypted.txt", ascii = TRUE)
  , file.exists("iris_encrypted.txt")
  , decrypt_file("iris_encrypted.txt", outfile = "iris_2.csv", ascii = TRUE)
  , file.exists("iris_2.csv")
  , tools::md5sum("iris_2.csv") == tools::md5sum("iris.csv")
  , unlink("iris.csv") == 0
  , unlink("iris_2.csv") == 0
  , unlink("iris_encrypted.txt") == 0
)

# asymmetric case:
alice <- keypair()
bob   <- keypair()
write.table(iris, "iris.csv")
all(
  encrypt_file("iris.csv", alice$private_key, bob$public_key, outfile = "iris_encrypted.bin")
  , file.exists("iris_encrypted.bin")
  , decrypt_file("iris_encrypted.bin", bob$private_key, alice$public_key, outfile = "iris_2.csv")
  , file.exists("iris_2.csv")
  , tools::md5sum("iris_2.csv") == tools::md5sum("iris.csv")
  , unlink("iris.csv") == 0
  , unlink("iris_2.csv") == 0
  , unlink("iris_encrypted.bin") == 0
)

}
