\name{default.saemix.plots}
\alias{default.saemix.plots}
\alias{basic.gof}
\alias{advanced.gof}
\alias{covariate.fits}
\alias{individual.fits}
\title{ Wrapper functions to produce certain sets of default plots}
\description{
These functions produce default sets of plots, corresponding to diagnostic or individual fits.
}
\usage{
default.saemix.plots(saemixObject, ...)
basic.gof(saemixObject, ...)
advanced.gof(saemixObject, ...)
covariate.fits(saemixObject, which = "parameters", ...)
individual.fits(saemixObject, ...)
}
\arguments{
  \item{saemixObject}{ an object returned by the \code{\link{saemix}} function}
  \item{which}{ for covariate fits, whether they should be produced with the EBE estimates of the parameters (the default) or with random effects (which="randeff")}
  \item{\dots}{ optional arguments passed to the plots}
}
\details{ These functions are wrapper functions designed to produce default sets of plots to help the user assess their model fits.
}
\value{
  \item{default.saemix.plots}{ by default, the following plots are produced: a plot of the data, convergence plots, plot of the likelihood by importance sampling (if computed), plots of observations versus predictions, scatterplots and distribution of residuals, boxplot of the random effects, correlations between random effects, distribution of the parameters, VPC}
  \item{basic.gof}{ basic goodness-of-fit plots: convergence plots, plot of the likelihood by importance sampling (if computed), plots of observations versus predictions}
  \item{advanced.gof}{ advanced goodness-of-fit plots: scatterplots and distribution of residuals, VPC,...}
  \item{covariate.fits}{ plots of all estimated parameters versus all covariates in the dataset}
  \item{individual.fits}{ plots of individual predictions (line) overlayed on individual observations (dots) for all subjects in the dataset}
}
\references{ Kuhn E, Lavielle M. Maximum likelihood estimation in nonlinear mixed effects models. Computational Statistics and Data Analysis 49, 4 (2005), 1020-1038.

Comets E, Lavenu A, Lavielle M. SAEMIX, an R version of the SAEM algorithm. 20th meeting of the Population Approach Group in Europe, Athens, Greece (2011), Abstr 2173.
}
\author{ Emmanuelle Comets <emmanuelle.comets@inserm.fr>, Audrey Lavenu, Marc Lavielle.
}
\seealso{ \code{\link{saemix}}, \code{\link{saemix.plot.data}}, \code{\link{saemix.plot.setoptions}}, \code{\link{plot.saemix}}}
\examples{
data(theo.saemix)

saemix.data<-saemixData(name.data=theo.saemix,header=TRUE,sep=" ",na=NA, 
  name.group=c("Id"),name.predictors=c("Dose","Time"),
  name.response=c("Concentration"),name.covariates=c("Weight","Sex"),
  units=list(x="hr",y="mg/L",covariates=c("kg","-")), name.X="Time")

model1cpt<-function(psi,id,xidep) { 
	  dose<-xidep[,1]
	  tim<-xidep[,2]  
	  ka<-psi[id,1]
	  V<-psi[id,2]
	  CL<-psi[id,3]
	  k<-CL/V
	  ypred<-dose*ka/(V*(ka-k))*(exp(-k*tim)-exp(-ka*tim))
	  return(ypred)
}

saemix.model<-saemixModel(model=model1cpt,
  description="One-compartment model with first-order absorption", 
  psi0=matrix(c(1.,20,0.5,0.1,0,-0.01),ncol=3, byrow=TRUE,
  dimnames=list(NULL, c("ka","V","CL"))),transform.par=c(1,1,1),
  covariate.model=matrix(c(0,1,0,0,0,0),ncol=3,byrow=TRUE),fixed.estim=c(1,1,1),
  covariance.model=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),
  omega.init=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),error.model="constant")

# Reducing the number of iterations due to time constraints for CRAN
saemix.options<-list(seed=632545,save=FALSE,save.graphs=FALSE,nbiter.saemix=c(100,100))

saemix.fit<-saemix(saemix.model,saemix.data,saemix.options)

default.saemix.plots(saemix.fit)

# Not run (time constraints for CRAN)
# basic.gof(saemix.fit)

# Not run (time constraints for CRAN)
# advanced.gof(saemix.fit)

individual.fits(saemix.fit)

}
\keyword{plots}
