% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beta.R
\name{Beta}
\alias{Beta}
\title{Small Area Estimation using Hierarchical Bayesian under Beta Distribution}
\usage{
Beta(
  formula,
  iter.update = 3,
  iter.mcmc = 2000,
  thin = 1,
  burn.in = 1000,
  data
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{iter.update}{Number of updates with default \code{3}}

\item{iter.mcmc}{Number of total iterations per chain with default \code{2000}}

\item{thin}{Thinning rate, must be a positive integer with default \code{1}}

\item{burn.in}{Number of iterations to discard at the begining with default \code{1000}}

\item{data}{The data frame}
}
\value{
This function returns a list of the following objects:
   \item{Est}{A vector with the values of Small Area mean Estimates using Hierarchical bayesian method }
   \item{sd}{A vector with the values of Standard deviation of Small Area Mean Estimates using Hierarchical bayesian method}
   \item{refVar}{Estimated random effect variances}
   \item{coefficient}{A dataframe with the estimated model coefficient}
   \item{plot}{Trace, Dencity, Autocorrelation Function Plot of MCMC samples}
}
\description{
This function is implemented to variable of interest \eqn{(y)} that assumed to be a Beta Distribution. The range of data must be \eqn{0<y<1}. The data proportion is supposed to be implemented with this function.
}
\examples{


#Compute Fitted Model
#y ~ x1 +x2


## For data without any nonsampled area
## Load Dataset
data(dataBeta)
saeHBbeta <- Beta(formula = y~x1+x2,iter.update=1,iter.mcmc = 1000,
                   burn.in = 200,data = dataBeta)
#the setting of iter.update, iter.mcmc, and burn.in in this example
#is considered to make the example execution time be faster.

#Result
saeHBbeta$Est                                 #Small Area mean Estimates
saeHBbeta$sd                                  #Standard deviation of Small Area Mean Estimates
saeHBbeta$refVar                              #refVar
saeHBbeta$coefficient                         #coefficient
#Load Library 'coda' to execute the plot
#autocorr.plot(saeHBbeta$plot[[3]]) is used to  #ACF Plot
#plot(saeHBbeta$plot[[3]]) is used to   #Dencity and trace plot


## For data without any nonsampled area use dataBetaNs


}
