% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trendscatter.R
\name{trendscatter}
\alias{trendscatter}
\alias{trendscatter.default}
\alias{trendscatter.formula}
\title{Trend and scatter plot}
\usage{
trendscatter(x, ...)

\method{trendscatter}{default}(x, y = NULL, f = 0.5, xlab = NULL, ylab = NULL, main = NULL, ...)

\method{trendscatter}{formula}(
  x,
  f = 0.5,
  data = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  ...
)
}
\arguments{
\item{x}{the coordinates of the points in the scatter plot. Alternatively, a formula.}

\item{\dots}{Optional arguments}

\item{y}{the y coordinates of the points in the plot, ignored if \code{x} is a
function.}

\item{f}{the smoother span. This gives the proportion of points in the plot
which influence the smooth at each value. Larger values give more
smoothness.}

\item{xlab}{a title for the x axis: see \code{\link{title}}.}

\item{ylab}{a title for the y axis: see \code{\link{title}}.}

\item{main}{a title for the plot: see \code{\link{title}}.}

\item{data}{an optional data frame containing the variables in the model.}
}
\value{
Returns the plot.
}
\description{
Plots a scatter plot for the variables x, y along with a lowess smooth for
the underlying trend. One standard deviation error bounds for the scatter
about this trend are also plotted.
}
\section{Methods (by class)}{
\itemize{
\item \code{trendscatter(default)}: Trend and scatter plot

\item \code{trendscatter(formula)}: Trend and scatter plot

}}
\examples{

# A simple polynomial
x = rnorm(100)
e = rnorm(100)
y = 2 + 3 * x - 2 * x^2 + 4 * x^3 + e
trendscatter(y ~ x)

# An exponential growth curve
e = rnorm(100, 0, 0.1)
y = exp(5 + 3 * x + e)
trendscatter(log(y) ~ x)

# Peruvian Indians data
data(peru.df)
trendscatter(BP ~ weight, data = peru.df)

# Note: this usage is deprecated
with(peru.df,trendscatter(weight,BP))

}
\seealso{
\code{\link{residPlot}}
}
\keyword{hplot}
