% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ryt_get_comments.R
\name{ryt_get_comments}
\alias{ryt_get_comments}
\title{Returns a list of comment threads of video or channel}
\usage{
ryt_get_comments(
  video_id = NULL,
  channel_id = NULL,
  text_format = c("plainText", "html")
)
}
\arguments{
\item{video_id}{YouTUbe Video ID}

\item{channel_id}{YouTube Channel ID}

\item{text_format}{Set this parameter's value to html or plainText to instruct the API to return the comments left by users in html formatted or in plain text. The default value is plainText}
}
\value{
tibble with comments
}
\description{
Returns a list of comment threads of video or channel
}
\examples{
\dontrun{
# all comments
comments <- ryt_get_comments()

# videos comments
video_comments <- ryt_get_comments(video_id = 'fW7gGS^G78')
}
}
\seealso{
\href{https://developers.google.com/youtube/v3/docs/commentThreads/list}{Reporting API Documentation}.
}
