% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bicop_plot.R
\name{plot.bicop_dist}
\alias{plot.bicop_dist}
\alias{contour.bicop_dist}
\alias{plot.bicop}
\alias{contour.bicop}
\title{Plotting tools for \code{bicop_dist} and \code{bicop} objects}
\usage{
\method{plot}{bicop_dist}(x, type = "surface", margins, size, ...)

\method{plot}{bicop}(x, type = "surface", margins, size, ...)

\method{contour}{bicop_dist}(x, margins = "norm", size = 100L, ...)

\method{contour}{bicop}(x, margins = "norm", size = 100L, ...)
}
\arguments{
\item{x}{\code{bicop_dist object.}}

\item{type}{plot type; either \code{"surface"} or \code{"contour"}.}

\item{margins}{options are: \code{"unif"} for the original copula density,
\code{"norm"} for the transformed density with standard normal margins,
\code{"exp"} with standard exponential margins, and  \code{"flexp"} with
flipped exponential margins. Default is \code{"norm"} for \code{type =
  "contour"}, and \code{"unif"} for \code{type = "surface"}.}

\item{size}{integer; the plot is based on values on a \verb{size x size} grid,
default is 100.}

\item{\dots}{optional arguments passed to \code{\link[graphics:contour]{graphics::contour()}} or
\code{\link[lattice:cloud]{lattice::wireframe()}}.}
}
\description{
There are several options for plotting bicop_dist objects. The density of a
bivariate copula density can be visualized as surface/perspective or contour
plot. Optionally, the density can be coupled with standard normal margins
(default for contour plots).
}
\examples{

## construct bicop_dist object for a student t copula
obj <- bicop_dist(family = "t", rotation = 0, parameters = c(0.7, 4))

## plots
plot(obj) # surface plot of copula density
contour(obj) # contour plot with standard normal margins
contour(obj, margins = "unif") # contour plot of copula density
}
\seealso{
\code{\link[=bicop_dist]{bicop_dist()}}, \code{\link[graphics:contour]{graphics::contour()}}, \code{\link[lattice:cloud]{lattice::wireframe()}}
}
\keyword{plot}
