% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bicop.R
\name{bicop_dist}
\alias{bicop_dist}
\title{Bivariate copula models}
\usage{
bicop_dist(
  family = "indep",
  rotation = 0,
  parameters = numeric(0),
  var_types = c("c", "c")
)
}
\arguments{
\item{family}{the copula family, a string containing the family name (see
\emph{Details} for all possible families).}

\item{rotation}{the rotation of the copula, one of \code{0}, \code{90}, \code{180}, \code{270}.}

\item{parameters}{a vector or matrix of copula parameters.}

\item{var_types}{variable types, a length 2 vector; e.g., \code{c("c", "c")} for
both continuous (default), or \code{c("c", "d")} for first variable continuous
and second discrete.}
}
\value{
An object of class \code{bicop_dist}, i.e., a list containing:
\itemize{
\item \code{family}, a \code{character} indicating the copula family.
\item \code{rotation}, an \code{integer} indicating the rotation (i.e., either 0, 90, 180,
or 270).
\item \code{parameters}, a \code{numeric} vector or matrix of parameters.
\item \code{npars}, a \code{numeric} with the (effective) number of parameters.
\item \code{var_types}, the variable types.
}
}
\description{
Create custom bivariate copula models by specifying the family, rotation,
parameters, and variable types.
}
\details{
\subsection{Implemented families}{\tabular{lll}{
   type \tab name \tab name in R \cr
   - \tab Independence \tab "indep" \cr
   Elliptical \tab Gaussian \tab "gaussian" \cr
   " \tab Student t \tab "t" \cr
   Archimedean \tab Clayton \tab "clayton" \cr
   " \tab Gumbel \tab "gumbel" \cr
   " \tab Frank \tab "frank" \cr
   " \tab Joe \tab "joe" \cr
   " \tab Clayton-Gumbel (BB1) \tab "bb1" \cr
   " \tab Joe-Gumbel (BB6) \tab "bb6" \cr
   " \tab Joe-Clayton (BB7) \tab "bb7" \cr
   " \tab Joe-Frank (BB8) \tab "bb8" \cr
   Extreme-value \tab Tawn \tab "tawn" \cr
   Nonparametric \tab Transformation kernel \tab "tll" \cr
}

}
}
\examples{
## Clayton 90° copula with parameter 3
cop <- bicop_dist("clayton", 90, 3)
cop
str(cop)

## visualization
plot(cop)
contour(cop)
plot(rbicop(200, cop))

## BB8 copula model for discrete data
cop_disc <- bicop_dist("bb8", 0, c(2, 0.5), var_types = c("d", "d"))
cop_disc

}
\seealso{
\code{\link[=bicop_dist]{bicop_dist()}}, \code{\link[=plot.bicop]{plot.bicop()}}, \code{\link[=contour.bicop]{contour.bicop()}}, \code{\link[=dbicop]{dbicop()}},
\code{\link[=pbicop]{pbicop()}}, \code{\link[=hbicop]{hbicop()}}, \code{\link[=rbicop]{rbicop()}}
}
