% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_docx.R
\name{write_docx}
\alias{write_docx}
\title{Microsoft Word Graphics Device}
\usage{
write_docx(file, code, pagesize = c(width = 8.5, height = 11),
  margins = c(left = 1, right = 1, top = 1, bottom = 1), ...)
}
\arguments{
\item{file}{filename of the Microsoft Word document to produce. File
extension must be \code{.docx}.}

\item{code}{Plotting code to execute}

\item{pagesize}{Word document page size in inches.
A named vector (\code{width} and \code{height}).}

\item{margins}{Word document margins size in inches.
A named vector (\code{left}, \code{right}, \code{top}, \code{bottom}).}

\item{...}{arguments for \code{fun} (passed on to \code{\link{dml_docx}}.)}
}
\description{
A graphical device for Microsoft Word documents.
}
\examples{
\donttest{
write_docx(file = "my_plot_1.docx", code = plot(rnorm(10)) )
write_docx(file = "my_plot_2.docx", code = barplot(1:7, col = 1:7))
}
}
\keyword{device}

