% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/session.R
\name{jump_to}
\alias{follow_link}
\alias{jump_to}
\title{Navigate to a new url.}
\usage{
jump_to(x, url, ...)

follow_link(x, i, css, xpath, ...)
}
\arguments{
\item{x}{A session.}

\item{url}{A URL, either relative or absolute, to navigate to.}

\item{...}{Any additional httr configs to apply to this request.}

\item{i}{You can select with: \describe{
  \item{an integer}{selects the ith link}
  \item{a string}{first link containing that text (case sensitive)}
}}

\item{css}{Nodes to select. Supply one of \code{css} or \code{xpath}
depending on whether you want to use a css or xpath selector.}

\item{xpath}{Nodes to select. Supply one of \code{css} or \code{xpath}
depending on whether you want to use a css or xpath selector.}
}
\description{
\code{jump_to()} takes a url (either relative or absolute);
\code{follow_link} takes an expression that refers to a link (an \code{<a>}
tag) on the current page.
}
\examples{
\donttest{
s <- html_session("http://had.co.nz")
s \%>\% jump_to("thesis/")
s \%>\% follow_link("vita")
s \%>\% follow_link(3)
s \%>\% follow_link("vita")
}
}

