% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws.R
\name{draws_min}
\alias{draws_min}
\alias{draws_max}
\alias{draws_min.rvec_chr}
\alias{draws_min.rvec}
\alias{draws_max.rvec_chr}
\alias{draws_max.rvec}
\title{Minima and Maxima Across Random Draws}
\usage{
draws_min(x, na_rm = FALSE)

draws_max(x, na_rm = FALSE)

\method{draws_min}{rvec_chr}(x, na_rm = FALSE)

\method{draws_min}{rvec}(x, na_rm = FALSE)

\method{draws_max}{rvec_chr}(x, na_rm = FALSE)

\method{draws_max}{rvec}(x, na_rm = FALSE)
}
\arguments{
\item{x}{An object of class \link[=rvec]{rvec}.}

\item{na_rm}{Whether to remove NAs before
calculating minima and maxima. Default is \code{FALSE}.}
}
\value{
A vector.
}
\description{
Apply \code{min} or \code{max} across random draws.
}
\examples{
m <- rbind(a = c(1,  -3,  2),
           b = c(Inf,  0,   -Inf),
           c = c(0.2, 0.3,  0.1))
x <- rvec(m)
x
draws_min(x)
draws_max(x)
}
\seealso{
Apply pre-specified functions across draws:
\itemize{
\item \code{\link[=draws_all]{draws_all()}}
\item \code{\link[=draws_any]{draws_any()}}
\item \code{\link[=draws_median]{draws_median()}}
\item \code{\link[=draws_mean]{draws_mean()}}
\item \code{\link[=draws_mode]{draws_mode()}}
\item \code{\link[=draws_ci]{draws_ci()}}
\item \code{\link[=draws_quantile]{draws_quantile()}}
}

Apply arbitrary function across draws:
\itemize{
\item \code{\link[=draws_fun]{draws_fun()}}
}

For additional functions for summarising random draws, see
\href{https://CRAN.R-project.org/package=tidybayes}{tidybayes}
and \href{https://CRAN.R-project.org/package=ggdist}{ggdist}.
Function \code{\link[=as_list_col]{as_list_col()}} converts rvecs into a
format that \code{tidybayes} and \code{ggdist} can work with.
}
