% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws.R
\name{draws_all}
\alias{draws_all}
\alias{draws_all.rvec_chr}
\alias{draws_all.rvec}
\alias{draws_any}
\alias{draws_any.rvec_chr}
\alias{draws_any.rvec}
\title{Logical Operations Across Random Draws}
\usage{
draws_all(x, na_rm = FALSE)

\method{draws_all}{rvec_chr}(x, na_rm = FALSE)

\method{draws_all}{rvec}(x, na_rm = FALSE)

draws_any(x, na_rm = FALSE)

\method{draws_any}{rvec_chr}(x, na_rm = FALSE)

\method{draws_any}{rvec}(x, na_rm = FALSE)
}
\arguments{
\item{x}{An object of class \link[=rvec]{rvec}.}

\item{na_rm}{Whether to remove NAs before
calculating summaries. Default is \code{FALSE}.}
}
\value{
A vector.
}
\description{
Apply \code{all} or \code{any} logical summaries
across random draws.
}
\examples{
m <- rbind(a = c(TRUE,  FALSE,  TRUE),
           b = c(TRUE,  TRUE,   TRUE),
           c = c(FALSE, FALSE,  FALSE))
x <- rvec(m)
x
draws_all(x)
draws_any(x)
}
\seealso{
Apply pre-specified functions across draws:
\itemize{
\item \code{\link[=draws_median]{draws_median()}}
\item \code{\link[=draws_mean]{draws_mean()}}
\item \code{\link[=draws_mode]{draws_mode()}}
\item \code{\link[=draws_ci]{draws_ci()}}
\item \code{\link[=draws_quantile]{draws_quantile()}}
}

Apply arbitrary function across draws:
\itemize{
\item \code{\link[=draws_fun]{draws_fun()}} to apply abritrary functions
}

For additional functions for summarising random draws, see
\href{https://CRAN.R-project.org/package=tidybayes}{tidybayes}
and \href{https://CRAN.R-project.org/package=ggdist}{ggdist}.
Function \code{\link[=as_list_col]{as_list_col()}} converts rvecs into a
format that \code{tidybayes} and \code{ggdist} can work with.
}
