% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOrders.R
\name{getOrders}
\alias{getOrders}
\title{Retrieve Orders Information from Brokers}
\usage{
getOrders(
  src = "",
  board = "MOEX",
  api.key = "",
  orderId = "",
  clientId = "",
  stopOrders = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{src}{Character string specifying the source broker/exchange (e.g., "tinkoff", "finam", "alor")}

\item{board}{Character string specifying the trading board (default is "MOEX")}

\item{api.key}{Character string specifying the API key for the broker/exchange}

\item{orderId}{Character string specifying the order ID to retrieve (default is "")}

\item{clientId}{Character string specifying the client ID for the broker/exchange}

\item{stopOrders}{Logical specifying whether to retrieve stop orders (default is FALSE)}

\item{verbose}{Logical specifying whether to display additional information (default is TRUE)}
}
\value{
A list containing order information from the broker/exchange
}
\description{
This function retrieves information about orders from different brokers/exchanges
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
# Retrieve all orders from Tinkoff
getOrders(src = "tinkoff", api.key = "your_api_key", clientId = "your_client_id")

# Retrieve all orders from Finam
getOrders(src = "finam", api.key = "your_api_key", clientId = "your_client_id")

# Retrieve all orders from Alor
getOrders(src = "alor", api.key = "your_api_key", clientId = "your_client_id")
}
\seealso{
\code{\link{getTrades}} \code{\link{cancelOrder}} \code{\link{placeOrder}}
}
\author{
Vyacheslav Arbuzov
}
