% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/literature.R
\name{literature}
\alias{literature}
\title{Downloads literature from SMML Literature DB}
\usage{
literature(x, spec_type = c("plant", "fungus"), process = TRUE)
}
\arguments{
\item{x}{a vector of class \code{character} containing fungal or plant species names}

\item{spec_type}{a character string specifying the type of \code{spec}. Can be either
\code{"plant"} or \code{"fungus"}}

\item{process}{logical, if \code{TRUE} downloading and extraction process is displayed

an object of class \code{list}}
}
\value{
a vector of mode \code{list} with literature entries for \code{x}
}
\description{
Searches and downloads literature entries from the SMML Literature database
}
\examples{
\dontrun{
x <- "Polyporus badius"
lit <- literature(x, process = TRUE, spec_type = "fungus")
lit
}
}
\author{
Franz-Sebastian Krah
}

