% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packs.R
\name{column-pack}
\alias{column-pack}
\title{Column rule pack}
\description{
Column rule pack is a \link[=rule-packs]{rule pack} which defines a set of rules
for columns as a whole, i.e. functions which convert columns of interest to
logical values. It should return a data frame with the following properties:
\itemize{
\item Number of rows equals to \strong{one}.
\item Column names should be treated as concatenation of
\bold{'check column name' + 'separator' + 'rule name'}.
\item Values indicate whether the \strong{column as a whole} follows the rule.
}
}
\details{
This format is inspired by \code{dplyr}'s
\link[dplyr:summarise_all]{scoped variants of summarise()} applied to non-grouped
data.

The most common way to define column pack is by creating a \link[magrittr:pipe]{functional sequence} with no grouping and ending with one of:
\itemize{
\item \code{summarise_all(.funs = rules(...))}.
\item \code{summarise_if(.predicate, .funs = rules(...))}.
\item \code{summarise_at(.vars, .funs = rules(...))}.
}

\strong{Note} that (as of \code{dplyr} version 0.7.4) when only one column is
summarised, names of the output don't have a necessary structure. The 'check
column name' is missing which results (after \link[=expose]{exposure}) into empty
string in \code{var} column of \link[=ruler-report]{validation report}. The current way
of dealing with this is to name the input column (see examples).
}
\section{Using rules()}{

Using \code{\link[=rules]{rules()}} to create list of functions for scoped \code{dplyr} "mutating"
verbs (such as \link[dplyr:summarise_all]{summarise_all()} and
\link[dplyr:transmute_all]{transmute_all()}) is recommended because:
\itemize{
\item It is a convenient way to ensure consistent naming of rules without manual
name.
\item It adds a common prefix to all rule names. This helps in defining
separator as prefix surrounded by any number of non-alphanumeric values.
}
}

\examples{
# Validating present columns
numeric_column_rules <- . \%>\% dplyr::summarise_if(
  is.numeric,
  rules(mean(.) > 5, sd(.) < 10)
)
character_column_rules <- . \%>\% dplyr::summarise_if(
  is.character,
  rules(. \%in\% letters[1:4])
)

col_packs(
  num_col = numeric_column_rules,
  chr_col = character_column_rules
)

# Dealing with one column edge case
improper_pack <- . \%>\% dplyr::summarise_at(
  dplyr::vars(vs),
  rules(improper_is_chr = is.character)
)

proper_pack <- . \%>\% dplyr::summarise_at(
  dplyr::vars(vs = vs),
  rules(proper_is_chr = is.character)
)

mtcars \%>\%
  expose(col_packs(improper_pack, proper_pack)) \%>\%
  get_report()

}
\seealso{
\link[=data-pack]{Data pack}, \link[=group-pack]{group pack}, \link[=row-pack]{row pack}, \link[=cell-pack]{cell pack}.
}
