% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{class}
\name{SparreAndersenCapitalInjections-class}
\alias{SparreAndersenCapitalInjections-class}
\title{A formal S4 class SparreAndersenCapitalInjections}
\description{
A formal S4 class representation of Sparre Andersen's extension that
includes capital injections.
}
\details{
The model is defined as follows:
\deqn{X_(t) = u + ct + \sum_{k=1}^{N^{(+)}(t)} Y^{(+)}_k -
\sum_{i=1}^{N^{(-)}(t)} Y^{(-)}_i}
where \eqn{u} is the initial capital (\code{initial_capital}), \eqn{c} is the
premium rate (\code{premium_rate}), \eqn{N^{(+)}(t)} is the renewal process
of positive jumps (capital injections) defined by distribution of
interarrival times (\code{capital_injection_interarrival_generator} and
\code{capital_injection_interarrival_parameters}), \eqn{Y^{(+)}_k} are iid
capital injections' sizes (\code{capital_injection_size_generator}
and \code{capital_injection_size_parameters}), \eqn{N^{(-)}(t)} is the
renewal process of claims defined by distribution of interarrival times
(\code{claim_interarrival_generator} and
\code{claim_interarrival_parameters}), \eqn{Y^{(-)}_i} are iid claim sizes
(\code{claim_size_generator} and \code{claim_size_parameters}).

Objects of class can be created only by using the constructor
\code{\link{SparreAndersenCapitalInjections}}.
}
\section{Slots}{

\describe{
\item{\code{initial_capital}}{a length one numeric non-negative vector specifying an
initial capital.}

\item{\code{premium_rate}}{a length one numeric non-negative vector specifying a
premium rate.}

\item{\code{claim_interarrival_generator}}{a function indicating the random
generator of claims' interarrival times.}

\item{\code{claim_interarrival_parameters}}{a named list containing parameters for
the random generator of claims' interarrival times.}

\item{\code{claim_size_generator}}{a function indicating the random generator of
claims' sizes.}

\item{\code{claim_size_parameters}}{a named list containing parameters for the
random generator of claims' sizes.}

\item{\code{capital_injection_interarrival_generator}}{a function indicating
the random generator of capital injections' interarrival times.}

\item{\code{capital_injection_interarrival_parameters}}{a named list containing
parameters for the random generator of capital injections' interarrival
times.}

\item{\code{capital_injection_size_generator}}{a function indicating the random
generator of capital injections' sizes.}

\item{\code{capital_injection_size_parameters}}{a named list containing parameters
for the random generator of capital injections' sizes.}
}}

\references{
Breuera L., Badescu A. L. \emph{A generalised Gerber Shiu measure for
Markov-additive risk processes with phase-type claims and capital
injections}. Scandinavian Actuarial Journal, 2014(2): 93-115, 2014.
}
\seealso{
\code{\link{SparreAndersenCapitalInjections}}
}
