% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeline.R
\name{get_timeline}
\alias{get_timeline}
\alias{get_timelines}
\title{Get one or more user timelines (tweets posted by target user(s)).}
\usage{
get_timeline(user, n = 100, max_id = NULL, home = FALSE,
  parse = TRUE, check = TRUE, token = NULL, ...)

get_timelines(user, n = 100, max_id = NULL, home = FALSE,
  parse = TRUE, check = TRUE, token = NULL, ...)
}
\arguments{
\item{user}{Vector of user names, user IDs, or a mixture of both.}

\item{n}{Number of tweets to return per timeline. Defaults to 100.
Must be of length 1 or equal to length of user. This number should
not exceed 3200 as Twitter limits returns to the most recent 3,200
statuses posted or retweeted by each user.}

\item{max_id}{Character, returns results with an ID less than (that is,
older than) or equal to `max_id`.}

\item{home}{Logical, indicating whether to return a user-timeline
or home-timeline. By default, home is set to FALSE, which means
\code{get_timeline} returns tweets posted by the given user. To
return a user's home timeline feed, that is, the tweets posted by
accounts followed by a user, set the home to false.}

\item{parse}{Logical, indicating whether to return parsed
(data.frames) or nested list object. By default, \code{parse =
TRUE} saves users from the time [and frustrations] associated
with disentangling the Twitter API return objects.}

\item{check}{Logical indicating whether to remove check available
rate limit. Ensures the request does not exceed the maximum
remaining number of calls.  Defaults to TRUE.}

\item{token}{Every user should have their own Oauth (Twitter API) token. By
default \code{token = NULL} this function looks for the path to a saved
Twitter token via environment variables (which is what `create_token()`
sets up by default during initial token creation). For instruction on how
to create a Twitter token see the tokens vignette, i.e.,
`vignettes("auth", "rtweet")` or see \code{?tokens}.}

\item{...}{Further arguments passed on as parameters in API query.}
}
\value{
A tbl data frame of tweets data with users data attribute.
}
\description{
Returns up to 3,200 statuses posted to the timelines of each of one
or more specified Twitter users.
}
\examples{

\dontrun{

## get most recent 3200 tweets posted by Donald Trump's account
djt <- get_timeline("realDonaldTrump", n = 3200)

## data frame where each observation (row) is a different tweet
djt

## users data for realDonaldTrump is also retrieved
users_data(djt)

## retrieve timelines of mulitple users
tmls <- get_timeline(c("KFC", "ConanOBrien", "NateSilver538"), n = 1000)

## it's returned as one data frame
tmls

## count observations for each timeline
table(tmls$screen_name)

}

}
\seealso{
\url{https://developer.twitter.com/en/docs/tweets/timelines/api-reference/get-statuses-user_timeline}

Other tweets: \code{\link{get_favorites}},
  \code{\link{get_mentions}},
  \code{\link{get_my_timeline}},
  \code{\link{lists_statuses}},
  \code{\link{lookup_statuses}},
  \code{\link{search_tweets}}, \code{\link{tweets_data}},
  \code{\link{tweets_with_users}}
}
\concept{tweets}
